#
# This script is sourced from Linux.sh.
#

# Upstart takes care of ensuring the services are running, but we still want
# contribution to get restarted.
WEBTASK=''
SYNCTASK=''

start_service()
{
    initctl start symform$1
}

stop_service()
{
    local n="symform${1}"
    [ -f "/etc/init/${n}.conf" ] && initctl stop "$n"
}

install_init_scripts()
{
    # make sure the services start on boot using the upstart init system
    local src dst
    for src in "/opt/symform/scripts/platform/"*.upstart; do
        # centos doesn't emit filesystem or net-device-up...so we have to rely
        # on runlevels to indicate when to start up
        dst="/etc/init/$(basename "$src" .upstart).conf"
        if grep -q 'emits.* filesystem' /etc/init/*.conf; then
            install -m 644 "$src" "$dst"
        else
            sed -e 's/start on .*/start on runlevel [345]/' \
                -e 's/stop on .*/stop on runlevel [0126]/' \
                "$src" > "$dst"
        fi
    done
}
