/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.formmodel.interactive.hypo;

import com.ulcjava.applicationframework.application.ResourceMap;
import com.ulcjava.applicationframework.application.form.BeanFormDialog;
import com.ulcjava.base.application.BorderFactory;
import com.ulcjava.base.application.ULCBorderLayoutPane;
import com.ulcjava.base.application.ULCComponent;
import com.ulcjava.base.application.ULCLabel;
import com.ulcjava.base.application.ULCSeparator;
import com.ulcjava.base.application.util.Color;
import com.ulcjava.base.application.util.Dimension;

public class HypoFormDialog extends BeanFormDialog<HypoFormModel> {
    private ULCBorderLayoutPane fContentPane;
    
    public HypoFormDialog(HypoForm form) {
        super(form);
        
        ULCComponent contentPane = super.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 5));
        
        fContentPane = new ULCBorderLayoutPane();
        fContentPane.add(createHeader(), ULCBorderLayoutPane.NORTH);
        fContentPane.add(contentPane, ULCBorderLayoutPane.CENTER);
    }
    
    @Override
    public ULCComponent getContentPane() {
        return fContentPane;
    }
    
    private ULCComponent createHeader() {
        ULCLabel headerLabel = new ULCLabel();
        headerLabel.setName("header.Label");
        headerLabel.putClientProperty(ResourceMap.STYLE_CLIENT_PROPERTY, "Header");
        
        ULCLabel messageLabel = new ULCLabel();
        messageLabel.setPreferredSize(new Dimension(0, 16));
        messageLabel.setMinimumSize(new Dimension(0, 16));
        messageLabel.setName("message.Label");
        messageLabel.setVerticalAlignment(ULCLabel.TOP);
        messageLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        
        ULCLabel iconLabel = new ULCLabel();
        iconLabel.setVerticalAlignment(ULCLabel.CENTER);
        iconLabel.setName("icon.Label");
        
        ULCBorderLayoutPane inner = new ULCBorderLayoutPane(10, 10);
        inner.setOpaque(false);
        inner.add(headerLabel, ULCBorderLayoutPane.NORTH);
        inner.add(messageLabel, ULCBorderLayoutPane.CENTER);
        
        ULCBorderLayoutPane outer = new ULCBorderLayoutPane(10, 10);
        outer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        outer.setBackground(Color.white);
        outer.add(inner, ULCBorderLayoutPane.CENTER);
        outer.add(iconLabel, ULCBorderLayoutPane.EAST);
        
        ULCBorderLayoutPane result = new ULCBorderLayoutPane();
        result.add(outer, ULCBorderLayoutPane.CENTER);
        result.add(new ULCSeparator(), ULCBorderLayoutPane.SOUTH);
        
        return result;
    }
}
