
open SVG

val barStyle : css_style = STYLE "stroke: #FF0000; fill: #00FF00;"
val txtStyle : css_style = STYLE "font-family: Verdana; font-size: 14pt;"

fun barDraw (myP: string): xsvg =
     <xml><path d={myP} style={barStyle}/></xml>

fun barTxt (x:int) (y:int) (txt: string): xsvg =
    <xml><text x={show x} y={show y} dy="30" style={txtStyle}>{[txt]}</text>
    </xml>

fun uncurry3 [a][b][c][d] (f: a -> b -> c -> d) (p: a * b * c) = f p.1 p.2 p.3

fun concat (li: list string) = List.foldr String.append "" li

fun myBar (x:int) (h:int) (txt: string) = let
     val path = concat ("M" :: show x :: ",600" ::
                " v-" :: show h :: " h50" :: " v" :: show h :: " Z" :: [])
   in
      join (barDraw path) (barTxt x 600 txt)
   end  
     
val posHeightAndTexts: list (int * int * string) =
   (100, 200, "bar1") :: (200, 300, "bar2") :: (300, 400, "bar3") :: []

val bars: list xsvg = List.mp (uncurry3 myBar) posHeightAndTexts

fun main (): transaction page = return <xml><body>
  This is a test:
<div>
  <svg width="500pt" height="500pt" viewBox="0, 0, 1000, 1000">
       {List.foldr join <xml/> bars}    
  </svg>
</div>
</body></xml>

