/*  Urwid unicode character processing tables

    Copyright (C) 2006 Rebecca Breu.
    This file contains rewritten code of utable.py by Ian Ward.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Urwid web site: http://excess.org/urwid/
*/



#ifndef CUTABLE_H
#define CUTABLE_H
#ifdef __cplusplus
extern "C" {
#endif


// C API functions:
#define Py_GetWidth_NUM 0
#define Py_GetWidth_RETURN int
#define Py_GetWidth_PROTO (long ord)

#define Py_DecodeOne_NUM 1
#define Py_DecodeOne_RETURN void
#define Py_DecodeOne_PROTO (const unsigned char *text, int text_len, int pos, \
int *ret)

#define Py_DecodeOneRight_NUM 2
#define Py_DecodeOneRight_RETURN void
#define Py_DecodeOneRight_PROTO (const unsigned char *text, int text_len, \
int pos, int *ret)

// Total number of C API pointers:
#define PyCutable_API_pointers 3


#ifdef CUTABLE
// This section is used when compiling cutable.c 

static Py_GetWidth_RETURN Py_GetWidth Py_GetWidth_PROTO;
static Py_DecodeOne_RETURN Py_DecodeOne Py_DecodeOne_PROTO;
static Py_DecodeOneRight_RETURN Py_DecodeOneRight Py_DecodeOneRight_PROTO;

    
#else
// This section is used in modules that use cutable's API

static void **PyCutable_API;

#define Py_GetWidth \
(*(Py_GetWidth_RETURN (*)Py_GetWidth_PROTO) PyCutable_API[Py_GetWidth_NUM])
#define Py_DecodeOne \
(*(Py_DecodeOne_RETURN (*)Py_DecodeOne_PROTO) PyCutable_API[Py_DecodeOne_NUM])
#define Py_DecodeOneRight \
(*(Py_DecodeOneRight_RETURN (*)Py_DecodeOneRight_PROTO) \
PyCutable_API[Py_DecodeOneRight_NUM])

    
// Return -1 and set exception on error, 0 on success. 
static int import_cutable(void)
{
    PyObject *module = PyImport_ImportModule("cutable");

    if (module != NULL) {
        PyObject *c_api_object = PyObject_GetAttrString(module, "_C_API");
        if (c_api_object == NULL)
            return -1;
        if (PyCObject_Check(c_api_object))
            PyCutable_API = (void **)PyCObject_AsVoidPtr(c_api_object);
        Py_DECREF(c_api_object);
    }
    return 0;
}

#endif

#ifdef __cplusplus
}
#endif

#endif 
