package telnetbug.telnetbug;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

import org.apache.commons.net.telnet.TelnetClient;

public class Test 
{
	static class EchoServer extends Thread {
		
		boolean stop = false;
		ServerSocket ss;
		Socket cs;		
		
		public void run(){
			try{
				ss = new ServerSocket(4444);
				while(!stop){
					cs = ss.accept();
					InputStream is = cs.getInputStream();
					OutputStream os = cs.getOutputStream();
					while(!stop){
						try{
							String msg = read(is);
							if(msg==null) break;							
							write(os,msg);							
						}catch(IOException e){
							break;
						}
					}
				}
			}catch(IOException e){
				throw new RuntimeException(e);
			}
			finally{
				shutdown();
			}
		}
		
		public void shutdown(){
			stop = true;
			if(cs!=null) try{ cs.close(); }catch(IOException e){}
			if(ss!=null) try{ ss.close(); }catch(IOException e){}			
		}
	}
	
	static String read(InputStream is) throws IOException {
		String s = "";		
		while(true){
			int c = is.read();
			if(c==-1) return null;
			if(c==(int)'\n') break;
			if(c>126) throw new RuntimeException("Got char "+c);
			s += (char)c;
		}
		return s;				
	}
	
	static void write(OutputStream os, String msg) throws IOException {
		os.write((msg+"\n").getBytes("US-ASCII"));
		os.flush();
	}
		
	public static void main(String[] args) throws Exception {
		
		String testString = "abcdefghijklmnopqrstuvwxyz";
		
		EchoServer s = new EchoServer();
		try{
			s.start();
													
			int i=0;
			while(true){
				TelnetClient c = null;
				try{
					c = new TelnetClient();
					c.setReaderThread(false);
					c.connect("127.0.0.1",4444);					
					InputStream is = c.getInputStream();
					OutputStream os = c.getOutputStream();
					
					write(os,testString);
					String received = read(is);
					
					if(!received.equals(testString)){
						System.out.println(String.format("Failed on iteration %d:\n"+
								"sent\t\"%s\"\ngot\t\"%s\"",i,testString,received));
						break;					
					}					
					i++;
					try{ Thread.sleep(50); }catch(InterruptedException e){}
					System.out.print(".");
					
				}finally{
					if(c!=null) c.disconnect();
				}	
			}						
		}finally{
			s.shutdown();
		}
	}
}
