package com.example.geode.service;

import java.util.Optional;

import javax.transaction.Transactional;

import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.WritablePdxInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.example.geode.model.Customer;
import com.example.geode.repo.CustomerRepository;

@Component
public class CustomerService {

	@Autowired
	CustomerRepository repo;

	@Transactional
	public void saveCustomer1(Customer c) {
		System.out.println("Save entered");
		try {
			Optional<Customer> customer = repo.findById(c.getCid());

			if (!customer.isPresent()) {

				Thread.sleep(1000);
				repo.save(c);
				System.out.println("Save done");
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	/* Thread t2 & t3 should enter this and both will read
	 * Customer 1234 from cache.
	 * 
	 *  Thread t1 -> Update name A1 to A2
	 *  Thread t2 -> Update name A1 to A3
	 *  
	 *  I am expecting commit conflict as at least 1 thread has stale state 
	*/
	@Transactional
	public void updateCustomer(String customerId, String customerName) {
		System.out.println(Thread.currentThread().getName()  + " : Update entered");
		try {
			Optional<Customer> currentCopyHandle = repo.findById(customerId);

			if (currentCopyHandle.isPresent()) {

				Thread.sleep(1000);
				Customer currentCopy = ((Customer) ((PdxInstance) currentCopyHandle.get()).getObject());
				PdxInstance details = currentCopy.getDetails();
				
				WritablePdxInstance writableDetails = details.createWriter();
				System.out.println(Thread.currentThread().getName() + " : Current customer name >> " + details.getField("cname"));
				writableDetails.setField("name", customerName);
				
				currentCopy.setDetails(writableDetails);
				
				repo.save(currentCopy);
				
				Customer afterUpdate = (Customer) ((PdxInstance) repo.findById(customerId).get()).getObject();
				System.out.println(Thread.currentThread().getName() + " : Final Data >> " + JSONFormatter.toJSON(afterUpdate.getDetails()));
				System.out.println(Thread.currentThread().getName() + " : Update done");
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
