package nee.ignite;

import java.util.Arrays;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;

public class ClientNode {
	
	public static void main(String[] args) {
		try(Ignite ignite = Ignition.getOrStart(new IgniteConfiguration()
					   .setIgniteInstanceName("default")
					   .setClientMode(true)
					   .setPeerClassLoadingEnabled(true)
					   .setDeploymentMode(DeploymentMode.CONTINUOUS)
					   .setAtomicConfiguration(new AtomicConfiguration()
							   .setCacheMode(CacheMode.REPLICATED)
							   )
					   .setDiscoverySpi(new TcpDiscoverySpi()
							   .setIpFinder(new TcpDiscoveryVmIpFinder()
									   .setAddresses(Arrays.asList("127.0.0.1:47500..47599"))
									   )
							   ))) {
			System.out.println("Client node started");
			
			// This works
			long remoteLong = ignite.compute().call(() -> { return ignite.atomicLong("long", 0, false).get(); });
			System.out.println("remoteLong: " + remoteLong);
			
			// This works
			String remoteReference = ignite.compute().call(() -> { return ignite.atomicReference("reference", "", false).get(); });
			System.out.println("remoteReference: " + remoteReference);
			
			// This doesn't worko
			try {
				IgniteAtomicLong remoteAtomicLong = ignite.compute().call(() -> { return ignite.atomicLong("long", 0, false); });
				System.out.println("remoteAtomicLong: " + remoteAtomicLong.get());
			} catch (Exception x) {
				System.err.println("remoteAtomicLong: " + x.getMessage());
			}
			
			// This doesn't work
			try {
				IgniteAtomicReference<String> remoteAtomicReference = ignite.compute().call(() -> { return ignite.atomicReference("reference", "", false); });
				System.out.println("remoteAtomicReference: " + remoteAtomicReference.get());
			} catch (Exception x) {
				System.err.println("remoteAtomicReference: " + x.getMessage());
			}
			
			// This doesn't work
			try {
				IgniteAtomicLong atomicLong = ignite.atomicLong("long", 0, false);
				System.out.println("atomicLong: " + atomicLong.get());
			} catch (Exception x) {
				System.err.println("atomicLong: " + x.getMessage());
			}
			
			// This doesn't work
			try {
				IgniteAtomicReference<String> atomicReference = ignite.atomicReference("reference", "", false);
				System.out.println("atomicRefence: " + atomicReference.get());
			} catch (Exception x) {
				System.err.println("atomicRefence: " + x.getMessage());
			}
		}
		System.out.println("Client node stopped");
	}

}
