package nee.ignite;

import java.util.Arrays;

import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;

public class ServerNode {
	
	public static void main(String[] args) {
		try(Ignite ignite = Ignition.getOrStart(new IgniteConfiguration()
				   .setIgniteInstanceName("default")
				   .setClientMode(false)
				   .setPeerClassLoadingEnabled(true)
				   .setDeploymentMode(DeploymentMode.CONTINUOUS)
				   .setAtomicConfiguration(new AtomicConfiguration()
						   .setCacheMode(CacheMode.REPLICATED)
						   )
				   .setDiscoverySpi(new TcpDiscoverySpi()
						   .setIpFinder(new TcpDiscoveryVmIpFinder()
								   .setAddresses(Arrays.asList("127.0.0.1:47500..47599"))
								   )
						   .setLocalPort(47500)
						   .setLocalPortRange(100)
						   ))) {
			System.out.println("Server node started");
			ignite.atomicReference("reference", "hello world", true);
			ignite.atomicLong("long", 1, true);
			System.out.print("Server node ready");
			keepAlive();
		}
		System.out.println("Server node stopped");
	}
	
	static void keepAlive() {
		try { Thread.sleep(Long.MAX_VALUE);	} catch (InterruptedException ix) {	System.out.println("Server node interrupted"); }
	}

}
