<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:nav="http://apache.org/cocoon/lenya/navigation/1.0"
    xmlns="http://www.w3.org/1999/xhtml"
    exclude-result-prefixes="nav"
>


<xsl:template match="nav:site">
  <xsl:call-template name="breadcrumb"/>
  <ul id="nav">
    <xsl:apply-templates select="nav:node"/>
  </ul>
</xsl:template>

<xsl:template match="nav:node[@visibleinnav = 'false']" priority="42">
<!--
  priority raised so this will take precedence over the following
  template and hide the branch if an invisible item has a visible sub-item.
-->

</xsl:template>

<xsl:template name="breadcrumb">
  <xsl:for-each select="descendant-or-self::nav:node[@current='true']">
    <a href="@href"><xsl:value-of select="label"/></a>
    <xsl:text> </xsl:text>
  </xsl:for-each>    
</xsl:template>

<xsl:template match="nav:node[nav:node[@visibleinnav = 'true']]">
  <li>
    <xsl:element name="a">
      <xsl:if test="self::nav:node[@current='true']">
        <xsl:attribute name="class">
          <xsl:text>active</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <xsl:attribute name="href">
        <xsl:value-of select="@href"/>
      </xsl:attribute>
      <xsl:value-of select="nav:label"/>
    </xsl:element>
    <xsl:if test="descendant-or-self::nav:node[@current='true']">
      <ul>
      <xsl:apply-templates select="nav:node"/>
    </ul>
    </xsl:if>
  </li>
</xsl:template>

<xsl:template match="nav:node">
  <li>
    <xsl:element name="a">
      <xsl:if test="descendant-or-self::nav:node[@current='true']">
        <xsl:attribute name="class">
          <xsl:text>active</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <xsl:attribute name="href">
        <xsl:value-of select="@href"/>
      </xsl:attribute>
      <xsl:value-of select="nav:label"/>
    </xsl:element>
  </li>
</xsl:template>

</xsl:stylesheet>
