package edu.vt.iddl.meval.schema;

import java.util.*;
import org.hibernate.*;

/**
 * The Semesters at VT, as of 2007.  We have the following semesters:
 * Spring, Fall, Summer 1, Summer 2, and Summer (12 wk).
 * @author lally
 *
 */
public class Semester2007 implements TimeInterval {

	protected Date start, end;
	protected int id;
	protected String description;
	
	/** all the SemesterDates we pull out */
	static List<SemesterDate> allDates;
	
	/** Maps typeCodes to Names */
	static Hashtable<Integer,String> typeNameMap; 
	private final String SPRING_NAME = "Spring";
	private final String SUM1_NAME = "Summer 1";
	private final String SUM2_NAME = "Summer 2";
	private final String SUMMER_ALL_NAME = "Summer (12 wk)";
	private final String FALL_NAME = "Fall";
	private final int SPRING_ID = 1;
	private final int SUM1_ID = 2;
	private final int SUM2_ID = 3;
	private final int SUMMER_ALL_ID = 4;
	private final int FALL_ID = 5;
	
	private final int SEM2007_ID = 2007;
	
	protected int yearForDate(Date d) {
		GregorianCalendar c = new GregorianCalendar ();
		c.setTime (d);
		return c.get(Calendar.YEAR);
	}
	
	public String getDescription() {
		return description;
	}

	public Date getEnd() {
		return end;
	}

	public String getIdentifier() {
		StringBuffer result = new StringBuffer ();
		result.append(yearForDate(start) + "");
		String[] months={ "00", "01", "06", "07", "07w", "09" };
		result.append(months[id]);
		return result.toString();
	}

	public Date getStart() {
		return start;
	}

	protected Semester2007 (Date start, Date end, int id) {
		this.start = start;
		this.end = end;
		this.id = id;
		this.description = typeNameMap.get(id);
	}
	
	@SuppressWarnings("unchecked")
	protected Semester2007 (String identifier, Session sess) {
		// extract the year and the month out of the identifier, then call periodsForTime().
		char[] buf = new char[4];
		identifier.getChars(0,4, buf,0);
		int year = Integer.parseInt(new String(buf));
		identifier.getChars(4,6, buf,0);
		int month = Integer.parseInt(new String(buf));
		GregorianCalendar c = new GregorianCalendar ();
		c.set(year, month, 1);
		List<Semester2007> results = periodsForTime(c.getTime(), sess);
		if (results.size() == 1) {
			Semester2007 v = (Semester2007) results.get(0);
			this.start = v.start;
			this.end = v.end;
			this.id = v.id;
			this.description = v.description;
		} else if (results.size() == 2){
			// figure out which one of the summers we are.
			boolean is12wk = false;
			if (identifier.length() != 6) {
				identifier.getChars(6,7, buf,0);
				if (buf[0]=='w')
					is12wk = true;
			}
			// now select the right one.
			for (Semester2007 v : results) {
				if (v.id == SUMMER_ALL_ID && is12wk) {
					this.start = v.start;
					this.end = v.end;
					this.id = v.id;
					this.description = v.description;
				} else if (!is12wk) {
					this.start = v.start;
					this.end = v.end;
					this.id = v.id;
					this.description = v.description;
				}
			}
		} else {
			this.description = "INVALID SEMESTER!";
			System.err.println (getClass().getName() + ": Couldn't extract oneself out of " + identifier);
		}
	}
	
	/**
	 * The factory method for getting the appropriate Semesters that apply for a given date.
	 */
	@SuppressWarnings("unchecked")
	public List periodsForTime(Date d, Session session) {
		if (typeNameMap == null) {
			typeNameMap = new Hashtable<Integer,String> ();
			typeNameMap.put(SPRING_ID, SPRING_NAME);
			typeNameMap.put(SUM1_ID, SUM1_NAME);
			typeNameMap.put(SUM2_ID, SUM2_NAME);
			typeNameMap.put(SUMMER_ALL_ID, SUMMER_ALL_NAME);
			typeNameMap.put(FALL_ID, FALL_NAME);
		}
		if (allDates == null) {
			allDates =  session.createQuery("from SemesterDate as date " +
				                             "where date.generation = " + 
				                              SEM2007_ID).list ();
		}
		 
		List result = new Vector ();
		// First, get the applicable semesters for that year.
		// Note: this could be shoved into a hashtable later for speed.
		SemesterDate[] thisYear = new SemesterDate[7];
		GregorianCalendar dcal = new GregorianCalendar();
		dcal.setTime(d);
		for (SemesterDate current : allDates) {
			// this is so stupid..  
			GregorianCalendar curcal = new GregorianCalendar();
			curcal.setTime(current.getDate());
			if (curcal.get(Calendar.YEAR) == dcal.get(Calendar.YEAR)) {
				thisYear[current.getTypeCode()] = current;
			}
		}
		// now we do some dumb comparisons, as we know the specifics of the current semester system.
		if (d.before(thisYear[SPRING_ID].getDate())) {
			GregorianCalendar beginYear = new GregorianCalendar();
			beginYear.set(dcal.get(Calendar.YEAR),Calendar.JANUARY,1); // start semester January 1st of that year.
			result.add(new Semester2007(beginYear.getTime(), thisYear[SPRING_ID].getDate(), SPRING_ID));
		} else if (d.before(thisYear[SUMMER_ALL_ID].getDate()) || d.before(thisYear[SUM2_ID].getDate())){
			result.add(new Semester2007(thisYear[SPRING_ID].getDate(), thisYear[SUMMER_ALL_ID].getDate(), SUMMER_ALL_ID));
			if (d.before(thisYear[SUM1_ID].getDate())) {
				result.add(new Semester2007(thisYear[SPRING_ID].getDate(), thisYear[SUM1_ID].getDate(), SUM1_ID));
			} else if (d.before(thisYear[SUM2_ID].getDate())) {
				result.add(new Semester2007(thisYear[SUM1_ID].getDate(), thisYear[SUM2_ID].getDate(), SUM1_ID));
			}
		} else {
			result.add (new Semester2007 (thisYear[SUMMER_ALL_ID].getDate(), thisYear[FALL_ID].getDate(), FALL_ID));
		}
		return result;
	}

}
