package edu.vt.iddl.meval.schema;

import java.util.*;

//
// Annotation imports.
import javax.persistence.Id;
import org.hibernate.annotations.*;

/**
 * This'll feel a little anal, but a SequencePoint is a static point in time, and all TimeIntervals 
 * are ordered by SequencePoints.  This allows stable iteration through TimeIntervals, by 
 * iterating through their containing SequencePoints.  A TimeInterval belongs to the last SequencePoint
 * that occurs before its end.  TimeIntervals should <b>not</b> span over more than one SequencePoint.
 * 
 * This helps as TimeIntervals are bound to the academic calendar, while SequencePoints 
 * are bound to the Gregorian calendar, which is much more stable.
 * @author lally
 *
 */
@Entity
public class SequencePoint {
	protected Long mId;
	protected Date mDate;
	protected String mDescription;
	
	SequencePoint () {}
	
	@Id
	public Long getId () {
		return mId;
	}
	
	public void setId (Long i) {
		mId = i;
	}
	
	public Date getDate() {
		return mDate;
	}
	
	public void setDate (Date d) {
		mDate = d;
	}
	
	public String getDescription () {
		return mDescription;
	}
	
	public void setDescription (String s) {
		mDescription = s;
	}
}
