package edu.vt.iddl.meval.schema;

import java.util.Date;
import java.util.List;

import org.hibernate.Session;

public interface TimeInterval {
	/**
	 * Will figure out which TimeIntervals can apply at date d.  Note that this is per-instance, not static.  This lets us
	 * have multiple differing timelines (say, for different campuses, etc.)
	 * @param d The date for the query
	 * @param session a Hibernate Session for DB access
	 * 
	 * Note: this may call TimeIntervalVersion.policyForPeriod to reroute if the current TimeInterval's out of range.
	 */
	public List periodsForTime (Date d, Session session);
	
	/**
	 * Start time
	 */
	public Date getStart();
	/**
	 * End Time
	 */
	public Date getEnd();
	
	/**
	 * A simple text description, like "Summer 1 2007" or "Fall 2007"
	 * @return
	 */
	public String getDescription();

	/**
	 * A unique identifier for this TimeInterval, good enough to re-create this from.  E.g. 200706-1
	 * @return A serialized from of this instance, only human-readable(ish).  
	 */
	public String  getIdentifier ();
}
