package edu.vt.iddl.meval.schema;
import edu.vt.iddl.meval.versioning.*;

/**
 * A Period of Surveying.  A way to identify semesters, without geting into 
 * trouble about multiple applicable semesters for a given point in time.
 * 
 *  It's versioned in case the calendar changes, or if we're dealing with different
 *  sites with diferent calendars, etc.
 */
public class TimeIntervalVersionPolicy implements VersionedPolicy{
	/**
	 * Until we have transitions, we'll just return the same one over and over. Obviously a singleton.
	 * @see edu.vt.iddl.meval.versioning.VersionedPolicy#policyForPeriod(edu.vt.iddl.meval.schema.TimeInterval)
	 */
	public Object policyForPeriod (TimeInterval period) {
		return period;
	}
	
	public TimeInterval intervalForIdentifier () {
		// de-serialization logic for intervals from a string, from their "getIdentifier" method
		// TODO: Implement this
		return null;
	}
}
