package outofmemoryerror.example;

import java.lang.management.ManagementFactory;
import java.util.logging.Logger;

import javax.management.ObjectName;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.servlet.WebBeansConfigurationListener;
import org.apache.webbeans.web.context.SessionContextManager;
import org.apache.webbeans.web.context.WebContextsService;

public class WebBeansConfigurationListenerExtended extends WebBeansConfigurationListener
      implements WebBeansConfigurationListenerExtendedMBean {

   private final static Logger LOG = WebBeansLoggerFacade.getLogger(WebBeansConfigurationListenerExtended.class);

   private final static String ORIG_ID_ATTR = "_ORIG_ID_";

   public WebBeansConfigurationListenerExtended() throws Exception {
      ManagementFactory.getPlatformMBeanServer()
            .registerMBean(this, new ObjectName("outofmemoryerror.example:type=WebBeansConfigurationListenerExtended"));
   }

   @Override
   public void sessionCreated(HttpSessionEvent event) {
      super.sessionCreated(event);

      HttpSession session = event.getSession();
      session.setAttribute(ORIG_ID_ATTR, session.getId());
      LOG.info(String.format("Start session with ID '%s'", session.getId()));
   }

   @Override
   public void sessionDestroyed(HttpSessionEvent event) {
      super.sessionDestroyed(event);

      HttpSession session = event.getSession();
      String origSessionId = (String) session.getAttribute(ORIG_ID_ATTR);
      LOG.info(String.format("Destroy session with ID '%s' (original ID '%s')", session.getId(), origSessionId));
   }

   @Override
   public int getSessionContextsSize() {
      WebContextsService webContextsService = (WebContextsService) lifeCycle.getContextService();
      SessionContextManager sessionContextManager = webContextsService.getSessionContextManager();
      return sessionContextManager.getAllSessionContexts().size();
   }

   @Override
   public void printSessionIDs() {
      WebContextsService webContextsService = (WebContextsService) lifeCycle.getContextService();
      SessionContextManager sessionContextManager = webContextsService.getSessionContextManager();
      StringBuilder sb = new StringBuilder("SessionContextManager, contexts stored for session IDs:\n");
      for (String sessionId : sessionContextManager.getAllSessionContexts().keySet()) {
         sb.append("\t").append(sessionId).append("\n");
      }
      System.out.println(sb.toString());
   }
}
