/*
 * @(#)Start.java   2011-10-16
 * 
 * Project: XCountry Version: 1.0
 *
 * Copyright (c) 2011 Tomas Stenlund
 *
 * This is part of the crosscountry java project for Stockvik SF
 *
 */



//~--- non-JDK imports --------------------------------------------------------

import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.collections.Map;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Frame;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;

//~--- JDK imports ------------------------------------------------------------

import java.io.IOException;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * The main startup class for this application.
 *
 *
 * @version        1.0, 2011-07-02
 * @author         Tomas Stenlund
 */
public class Start implements Application {

    /** The logger */
    static Logger logger = Logger.getLogger(Start.class.getName());

    /** Contains the display which is associated with this application */
    private Display display = null;

    /**
     * Resumes a suspended application.
     *
     *
     * @throws Exception
     */
    @Override
    public void resume() throws Exception {

        /* Nothing to do at all */
    }

    /**
     * Shuts down the application and closes all opened windows regardless of type.
     *
     *
     * @param arg0
     *
     * @return Wether or not the application should stop the shutdown or not
     *
     * @throws Exception
     */
    @Override
    public boolean shutdown(boolean arg0) throws Exception {
        for (int i = display.getLength() - 1; i >= 0; i--) {
            Window window = (Window) display.get(i);

            window.close();
        }

        return false;
    }

    /**
     * Starts up the application and initializes the main frame.
     *
     *
     * @param dsp
     * @param properties
     *
     * @throws Exception
     */
    @Override
    public void startup(Display dsp, Map<String, String> properties) throws Exception {
        logger.info("Starting up the application");

        /* Save th display for later use */
        this.display = dsp;

        /* Open up the normal frame */
        Frame mainFrame = null;

        try {
            BXMLSerializer bxmlSerializer = new BXMLSerializer();

            mainFrame = (Frame) bxmlSerializer.readObject(getClass().getResource("/cc/stenlund/test/Main.bxml"));
        } catch (SerializationException exception) {
            logger.log(Level.SEVERE, "Exception caught when creating main application window", exception);

            throw new RuntimeException(exception);
        } catch (IOException exception) {
            logger.log(Level.SEVERE, "Exception caught when creating main application window", exception);

            throw new RuntimeException(exception);
        }

        /* Listen for the close of the window so we can close down the application */
        mainFrame.getWindowStateListeners().add(new WindowStateListener() {
            @Override
            public Vote previewWindowClose(Window arg0) {

                /* Always approve the close */
                return Vote.APPROVE;
            }
            @Override
            public void windowCloseVetoed(Window arg0, Vote arg1) {

                /* Do nothing if vetoed */
            }
            @Override
            public void windowClosed(Window arg0, Display arg1, Window arg2) {

                /* Shut down the system */
                DesktopApplicationContext.exit();
            }
            @Override
            public void windowOpened(Window arg0) {}
        });

        /* Open the window */
        mainFrame.open(dsp);
    }

    /**
     * Suspends the execution of the application.
     *
     *
     * @throws Exception
     */
    @Override
    public void suspend() throws Exception {

        /* Nothing to do */
    }

    /**
     * @param args Command line arguments, same as Pivot
     */
    public static void main(String[] args) {
        DesktopApplicationContext.main(Start.class, args);
    }
}
