/*
 * @(#)ActionTest.java   2011-10-16
 * 
 * Project: XCountry Version: 1.0
 *
 * Copyright (c) 2011 Tomas Stenlund
 *
 * This is part of the crosscountry java project for Stockvik SF
 *
 */



package cc.stenlund.test;

//~--- non-JDK imports --------------------------------------------------------

import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dialog;

//~--- JDK imports ------------------------------------------------------------

import java.io.IOException;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Class description
 *
 *
 * @version        1.0, 2011-10-16
 * @author         Tomas Stenlund    
 */
public class ActionTest extends Action {

    /** The logger */
    static Logger logger = Logger.getLogger(ActionTest.class.getName());

    /**
     * Method description
     *
     *
     * @param source
     */
    @Override
    public void perform(Component source) {
        Dialog dialog;

        logger.fine("Action test perform");

        try {
            BXMLSerializer bxmlSerializer = new BXMLSerializer();

            dialog =
                (Dialog) bxmlSerializer.readObject(getClass().getResource("/cc/stenlund/test/StatusDistance.bxml"));
        } catch (SerializationException exception) {
            logger.log(Level.SEVERE, "Unable to instantiate Distance Timekeeping status", exception);

            throw new RuntimeException(exception);
        } catch (IOException exception) {
            logger.log(Level.SEVERE, "Unable to instantiate Distance Timekeeping status", exception);

            throw new RuntimeException(exception);
        }

        /* Open the dialog, but with no owner */
        dialog.setModal(false);
        dialog.open(source.getDisplay());
    }
}
