/*
 * @(#)Main.java   2011-10-16
 * 
 * Project: XCountry Version: 1.0
 *
 * Copyright (c) 2011 Tomas Stenlund
 *
 * This is part of the crosscountry java project for Stockvik SF
 *
 */



package cc.stenlund.test;

/*
* @(#)Main.java   2011-10-01
*
* Project: XCountry Version: 1.0
*
* Copyright (c) 2011 Tomas Stenlund
*
* This is part of the crosscountry java project for Stockvik SF
*
 */

//~--- non-JDK imports --------------------------------------------------------

import org.apache.pivot.beans.BXML;
import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.beans.Bindable;
import org.apache.pivot.collections.Map;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.Action.NamedActionDictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.Frame;

//~--- JDK imports ------------------------------------------------------------

import java.io.IOException;

import java.net.URL;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * The main application frame.
 *
 *
 * @version        1.0, 2011-07-02
 * @author         Tomas Stenlund
 */
public class Main extends Frame implements Bindable {

    /** The logger */
    static Logger logger = Logger.getLogger(Main.class.getName());

    /** Field description */
    @BXML
    private Button buttonTest = null;

    /**
     * Constructs the main class, i.e. adds the menu actions.
     *
     */
    public Main() {

        /* All menu actions */
        NamedActionDictionary nad = Action.getNamedActions();

        nad.put("test", new ActionTest());
    }

    /**
     * Initializes the controller class for the Main frame.
     *
     *
     * @param arg0 The map of items in the namespace
     * @param arg1 The location of the bxml file for the view
     * @param arg2 The resources used to create the view
     */
    @Override
    public void initialize(Map<String, Object> arg0, URL arg1, Resources arg2) {

        /* Create a button listener for the Test button operation */
        ButtonPressListener buttonTestPressListener = new ButtonPressListener() {
            @Override
            public void buttonPressed(Button button) {
                Dialog dialog;

                try {
                    BXMLSerializer bxmlSerializer = new BXMLSerializer();

                    dialog = (Dialog) bxmlSerializer.readObject(
                        getClass().getResource("/cc/stenlund/test/StatusDistance.bxml"));
                } catch (SerializationException exception) {
                    logger.log(Level.SEVERE, "Unable to instantiate Distance Timekeeping status", exception);

                    throw new RuntimeException(exception);
                } catch (IOException exception) {
                    logger.log(Level.SEVERE, "Unable to instantiate Distance Timekeeping status", exception);

                    throw new RuntimeException(exception);
                }

                dialog.setModal(false);
                dialog.open(Main.this.getDisplay());
            }
        };

        buttonTest.getButtonPressListeners().add(buttonTestPressListener);
    }
}
