package test;
import java.io.InputStream;
import java.util.*;

import javax.activation.DataSource;

import org.apache.cxf.common.util.SOAPConstants;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.gzip.GZIPFeature;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;


public class Client
{
	public static boolean GZIP = true;
	private static IWS client;
	
	public static void init(String address)
	{
		ClientProxyFactoryBean cfb = new ClientProxyFactoryBean();
		cfb.setServiceClass(IWS.class);
		cfb.setAddress(address);
		
		Map<String,Object> props = new HashMap<String, Object>();
		props.put(SOAPConstants.MTOM_ENABLED, Boolean.TRUE.toString());

		cfb.setProperties(props);
		cfb.getServiceFactory().setDataBinding(DataBindings.get());
        if (cfb.getFeatures() == null)
        {
        	cfb.setFeatures(new ArrayList<AbstractFeature>());
        }
        if (GZIP)
        {
        	cfb.getFeatures().add(new GZIPFeature());
        }
		
		client = (IWS) cfb.create();
		
		org.apache.cxf.endpoint.Client cl = ClientProxy.getClient(client);
		
		HTTPConduit cnd = (HTTPConduit)cl.getConduit();
		HTTPClientPolicy cpol = cnd.getClient();
		cpol.setConnectionTimeout(60 * 1000);
		cpol.setAllowChunking(false);
		cpol.setReceiveTimeout(60 * 1000);
		if (GZIP)
		{
			cpol.setAcceptEncoding("gzip");
		}
		cnd.setClient(cpol);
	}
	
	public static void runPerformanceTests(int COUNT) throws Exception
	{
		long t = System.currentTimeMillis();
		for (int i = 0; i < COUNT; i++)
		{
			DataSource ds = Client.get().xmlStream();
			
			byte[] buf = new byte[100 * 1024];
			InputStream is = ds.getInputStream();
			while (is.read(buf) >= 0)
			{
			}
			is.close();
		}
		long streaming = (System.currentTimeMillis() - t);
		
		t = System.currentTimeMillis();
		for (int i = 0; i < COUNT; i++)
		{
			String xml = Client.get().xmlString();
		}
		long string = (System.currentTimeMillis() - t);
		
		System.out.println("Elapsed time: streaming=" + streaming + ", string=" + string);
	}
	
	public static IWS get()
	{
		return client;
	}
	
	public static void main(String args[]) throws Exception
	{
		init("http://remote.server.com:9336/cxf_test");
		runPerformanceTests(100);
	}
}
