package test;
import java.util.*;

import org.apache.cxf.common.util.SOAPConstants;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.gzip.GZIPFeature;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;


public class Server
{
	public static boolean GZIP = false;
	public static boolean KEEPALIVE = false;
	private static org.apache.cxf.endpoint.Server server;
	
	private static void init()
	{
		if (server == null)
		{
	        /**
	         * Start main application server
	         */
	        CWS cws = new CWS();
	        ServerFactoryBean sfb = new ServerFactoryBean();
	
	        Map<String,Object> props = new HashMap<String, Object>();
	        props.put(SOAPConstants.MTOM_ENABLED, Boolean.TRUE.toString());
	        
	        sfb.setProperties(props);
	        sfb.getServiceFactory().setDataBinding(DataBindings.get());
	        sfb.setServiceClass(IWS.class);
	        sfb.setAddress(Main.address);
	        sfb.setServiceBean(cws);
	        if (sfb.getFeatures() == null)
	        {
	        	sfb.setFeatures(new ArrayList<AbstractFeature>());
	        }
	        if (GZIP)
	        {
	        	System.out.println("Enabling GZIP");
//	        	sfb.getFeatures().add(new FastInfosetFeature());
	        	sfb.getFeatures().add(new GZIPFeature());
	        }
	
	        server = sfb.create();
	        
	        if (KEEPALIVE)
	        {
	        	System.out.println("Enabling keep-alive");
		        HTTPServerPolicy spol = ((AbstractHTTPDestination) server.getDestination()).getServer();
		        spol.setHonorKeepAlive(true);
		        spol.setKeepAliveParameters("timeout=60, max=10;");
	        }
		}
	}
	
	public static org.apache.cxf.endpoint.Server get()
	{
		init();
		return server;
	}
	
	public static void main(String... args)
	{
		for (String arg : args)
		{
			if (arg != null)
			{
				if (arg.trim().equalsIgnoreCase("gzip"))
				{
					GZIP = true;
				}
				else if (arg.trim().equalsIgnoreCase("keepalive"))
				{
					KEEPALIVE = true;
				}
			}
		}
		init();
	}
}
