program cgiproject1;

{$mode objfpc}{$H+}

uses
  HTTPDefs, custweb, custcgi, main;

type

  { TMyCGIHandler }

  TMyCGIHandler = class(TCGIHandler)
  public
    procedure HandleRequest(AReq: TRequest; ARes: TResponse); override;
  end;

  TMyCGIApp = class(TCustomCGIApplication)
  protected
    function InitializeWebHandler: TWebHandler; override;
  end;

procedure TMyCGIHandler.HandleRequest(AReq: TRequest; ARes: TResponse);
begin
  if AReq.GetNextPathInfo = 'test' then
    CGITest(AReq, ARes)
  else
    CGIAbreHtml(AReq, ARes);
end;

function TMyCGIApp.InitializeWebHandler: TWebHandler;
begin
  Result := TMyCGIHandler.Create(self);
end;

begin
  With TMyCGIApp.Create(Nil) do
    try
      Initialize;
      Run;
    finally
      Free;
    end;
end.
