unit main;

{$mode objfpc}{$H+}

interface

uses
  SysUtils, HTTPDefs;

procedure CGITest(AReq: TRequest; ARes: TResponse);
procedure CGIAbreHtml(AReq: TRequest; ARes: TResponse);

implementation

procedure CGIAbreHtml(AReq: TRequest; ARes: TResponse);
var
  VFile: string;
begin
  VFile := ExtractFileDir(ParamStr(0)) + AReq.PathInfo;
  if FileExists(VFile) then
  begin
    ARes.Contents.LoadFromFile(VFile);
    ARes.Contents.Add(VFile);
  end else
  begin
    ARes.Content := '404';
  end;
end;

procedure CGITest(AReq: TRequest; ARes: TResponse);
const
  CBool: array[Boolean] of string = ('False', 'True');
var
  I: Integer;
begin
  ARes.Contents.Add('<h2>hello</h2>');
  ARes.Contents.Add('<form method="post" enctype="multipart/form-data" action="' + AReq.ScriptName + AReq.PathInfo + '">');
  ARes.Contents.Add('<input type="file" name="f">');
  ARes.Contents.Add('<input type="text" name="a" value="b">');
  ARes.Contents.Add('<input type="text" name="c" value="d">');
  ARes.Contents.Add('<input type="submit" value="Ok"');
  ARes.Contents.Add('</form>');
  ARes.Contents.Add('<hr/>');
  ARes.Contents.Add('QueryString: ' + AReq.QueryString);
  ARes.Contents.Add('QueryFields:');
  for I := 0 to Pred(AReq.QueryFields.Count) do
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.QueryFields[I]);
  ARes.Contents.Add('ContentFields:');
  for I := 0 to Pred(AReq.ContentFields.Count) do
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.ContentFields[I]);
  ARes.Contents.Add('Files:');
  for I := 0 to Pred(AReq.Files.Count) do
  begin
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.Files.Files[I].FileName + ' - ' +
     AReq.Files.Files[I].LocalFileName + ' - ' + AReq.Files.Files[I].ContentType);
  end;
  ARes.Contents.Add('Host: ' + AReq.Host);
  ARes.Contents.Add('ScriptName: ' + AReq.ScriptName);
  ARes.Contents.Add('PathInfo: ' + AReq.PathInfo);
  ARes.Contents.Add('Method: ' + AReq.Method);
  ARes.Contents.Add('URL: ' + AReq.URL);
  ARes.Contents.Add('<hr/>');
  ARes.Contents.Add('ReturnedPathInfo: ' + AReq.ReturnedPathInfo);
  ARes.Contents.Add('1-GetNextPathInfo: ' + AReq.GetNextPathInfo + ' - ReturnedPathInfo: ' + AReq.ReturnedPathInfo);
  ARes.Contents.Add('2-GetNextPathInfo: ' + AReq.GetNextPathInfo + ' - ReturnedPathInfo: ' + AReq.ReturnedPathInfo);
  ARes.Contents.Add('3-GetNextPathInfo: ' + AReq.GetNextPathInfo + ' - ReturnedPathInfo: ' + AReq.ReturnedPathInfo);
  ARes.Contents.Add('4-GetNextPathInfo: ' + AReq.GetNextPathInfo + ' - ReturnedPathInfo: ' + AReq.ReturnedPathInfo);
  ARes.Contents.Add('5-GetNextPathInfo: ' + AReq.GetNextPathInfo + ' - ReturnedPathInfo: ' + AReq.ReturnedPathInfo);
  ARes.Contents.Add('6-GetNextPathInfo: ' + AReq.GetNextPathInfo + ' - ReturnedPathInfo: ' + AReq.ReturnedPathInfo);
  ARes.Contents.Add('LocalPathPrefix: ' + AReq.LocalPathPrefix);
  ARes.Contents.Add('CommandLine: ' + AReq.CommandLine);
  ARes.Contents.Add('Command: ' + AReq.Command);
  ARes.Contents.Add('URI: ' + AReq.URI);
  ARes.Contents.Add('QueryString: ' + AReq.QueryString);
  ARes.Contents.Add('HeaderLine: ' + AReq.HeaderLine);
  ARes.Contents.Add('HandleGetOnPost: ' + CBool[AReq.HandleGetOnPost]);
  ARes.Contents.Add('Files:');
  for I := 0 to Pred(AReq.Files.Count) do
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.Files.Files[I].FileName + ' - ' +
     AReq.Files.Files[I].LocalFileName + ' - ' + AReq.Files.Files[I].ContentType);
  ARes.Contents.Add('Fields:');
  for I := 0 to Pred(AReq.FieldCount) do
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.Fields[I] + ' - ' + AReq.FieldNames[I] + ' - ' + AReq.FieldValues[I]);
  ARes.Contents.Add('CookieFields:');
  for I := 0 to Pred(AReq.CookieFields.Count) do
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.CookieFields[I]);
  ARes.Contents.Add('ContentFields:');
  for I := 0 to Pred(AReq.ContentFields.Count) do
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.ContentFields[I]);
  ARes.Contents.Add('QueryFields:');
  for I := 0 to Pred(AReq.QueryFields.Count) do
    ARes.Contents.Add(IntToStr(I) + ': ' + AReq.QueryFields[I]);
  ARes.Contents.Add('');

  ARes.Contents.Add('HttpVersion: ' + AReq.HttpVersion);
  ARes.Contents.Add('ProtocolVersion: ' + AReq.ProtocolVersion);
  ARes.Contents.Add('Accept: ' + AReq.Accept);
  ARes.Contents.Add('AcceptCharset: ' + AReq.AcceptCharset);
  ARes.Contents.Add('AcceptEncoding: ' + AReq.AcceptEncoding);
  ARes.Contents.Add('AcceptLanguage: ' + AReq.AcceptLanguage);
  ARes.Contents.Add('Authorization: ' + AReq.Authorization);
  ARes.Contents.Add('Connection: ' + AReq.Connection);
  ARes.Contents.Add('ContentEncoding: ' + AReq.ContentEncoding);
  ARes.Contents.Add('ContentLanguage: ' + AReq.ContentLanguage);
  ARes.Contents.Add('ContentLength: ' + IntToStr(AReq.ContentLength));
  ARes.Contents.Add('ContentType: ' + AReq.ContentType);
  ARes.Contents.Add('Cookie: ' + AReq.Cookie);
  ARes.Contents.Add('Date: ' + AReq.Date);
  ARes.Contents.Add('Expires: ' + AReq.Expires);
  ARes.Contents.Add('From: ' + AReq.From);
  ARes.Contents.Add('IfModifiedSince: ' + AReq.IfModifiedSince);
  ARes.Contents.Add('LastModified: ' + AReq.LastModified);
  ARes.Contents.Add('Location: ' + AReq.Location);
  ARes.Contents.Add('Pragma: ' + AReq.Pragma);
  ARes.Contents.Add('Referer: ' + AReq.Referer);
  ARes.Contents.Add('RetryAfter: ' + AReq.RetryAfter);
  ARes.Contents.Add('Server: ' + AReq.Server);
  ARes.Contents.Add('SetCookie: ' + AReq.SetCookie);
  ARes.Contents.Add('UserAgent: ' + AReq.UserAgent);
  ARes.Contents.Add('WWWAuthenticate: ' + AReq.WWWAuthenticate);
  ARes.Contents.Add('PathInfo: ' + AReq.PathInfo);
  ARes.Contents.Add('PathTranslated: ' + AReq.PathTranslated);
  ARes.Contents.Add('RemoteAddress: ' + AReq.RemoteAddress);
  ARes.Contents.Add('RemoteHost: ' + AReq.RemoteHost);
  ARes.Contents.Add('ScriptName: ' + AReq.ScriptName);
  ARes.Contents.Add('ServerPort: ' + IntToStr(AReq.ServerPort));
  ARes.Contents.Add('HTTPAccept: ' + AReq.HTTPAccept);
  ARes.Contents.Add('HTTPAcceptCharset: ' + AReq.HTTPAcceptCharset);
  ARes.Contents.Add('HTTPAcceptEncoding: ' + AReq.HTTPAcceptEncoding);
  ARes.Contents.Add('HTTPIfModifiedSince: ' + AReq.HTTPIfModifiedSince);
  ARes.Contents.Add('HTTPReferer: ' + AReq.HTTPReferer);
  ARes.Contents.Add('HTTUserAgent: ' + AReq.HTTPUserAgent);
  ARes.Contents.Add('Method: ' + AReq.Method);
  ARes.Contents.Add('URL: ' + AReq.URL);
  ARes.Contents.Add('Host: ' + AReq.Host);
  ARes.Contents.Add('HTTPXRequestedWith: ' + AReq.HTTPXRequestedWith);

  for I := 2 to Pred(ARes.Contents.Count) do
    ARes.Contents[I] := ARes.Contents[I] + '<br>';
end;

end.

