program integ

  implicit none
  
  ! var to store filename
  character(len=32) :: filename
  
  ! vars to store mesh info
  real(kind=8),    dimension(3)   :: mesh_origin
  integer(kind=4), dimension(3)   :: mesh_size
  real(kind=8),    dimension(3,3) :: mesh_unit
  
  ! vars associated with scalar fields
  real(kind=8), allocatable, dimension(:,:,:) :: mat_1
  real(kind=8) :: integ_1

  ! unit volume
  real(kind=8) :: dv


  ! parse command-line parameters 
  call GET_COMMAND_ARGUMENT( 1, filename )
 

  ! call cube_read_meshinfo
  call cube_read_meshinfo( filename, mesh_origin, mesh_size, mesh_unit )
  ! call calc_volume to calculate unit volume
  call calc_volume( mesh_unit, dv )


  ! allocate mat_1
  allocate( mat_1(mesh_size(1),mesh_size(2),mesh_size(3)) )
  ! read mat_1
  call cube_read_scafield( filename, mesh_size, mat_1 )


  ! calculate integral
  integ_1 = sum(mat_1) * dv
  ! output integral
  write (*,*) "the integral is:", integ_1
  

  ! deallocate data
  deallocate( mat_1 )

end program integ
