package myplugin;

import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;

import java.util.Properties;

/**
 * @goal dosomething
 * @description Description
 * @requiresProject false
 * @execute phase="generate-sources"
 */
public class MyMojo extends AbstractMojo {
	
    public void execute() throws MojoExecutionException {
    	try {
			Properties properties = new Properties();
			properties.put("archetypeArtifactId", "maven-archetype-quickstart");
//			properties.put("archetypeCatalog", "");
//			properties.put("archetypeRepository", "");
			properties.put("archetypeGroupId", "org.apache.maven.archetypes");
			properties.put("archetypeVersion", "1.1");
			properties.put("basedir", "somedir");
			properties.put("goals", "test");
			properties.put("groupId", "mygroup");
			properties.put("artifactId", "myexample");
			properties.put("version", "1.0-SNAPSHOT");
			properties.put("package", "mygroup");
	        ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setProperties(properties);
	        ArchetypeGenerationResult result = new ArchetypeGenerationResult();
	        
	        PlexusContainer container = new DefaultPlexusContainer();
	        ArchetypeGenerator archetypeGenerator = (ArchetypeGenerator) container.lookup(ArchetypeGenerator.class.getName());
	        archetypeGenerator.generateArchetype(request, result);
	        container.dispose();
		} catch (Exception e) {
			e.printStackTrace();
			throw new MojoExecutionException(e.getMessage());
		}
    }
    
}