package test;

import java.io.Console;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.forward.DefaultTcpipForwarderFactory;

public class ForwardSsh {
    public static void main( String[] args ) throws Exception {
        String host        = args[0];
        int    port        = 22;
        String fwdHost     = "localhost";
        int    fwdPort     = 10022;
        
        Console console = System.console();
        String  user    = console.readLine("User: ");
        String  pass    = new String(console.readPassword("Password: "));
        
        SshClient client = SshClient.setUpDefaultClient();
        client.setTcpipForwarderFactory(new DefaultTcpipForwarderFactory());
        client.start();
        
        ClientSession session = client.connect(host, port).await().getSession();
        session.authPassword(user, pass);
        
        SshdSocketAddress localAddr  = new SshdSocketAddress(fwdHost, fwdPort);
        SshdSocketAddress remoteAddr = new SshdSocketAddress(host, 22);
        session.startLocalPortForwarding(localAddr, remoteAddr);
        
        System.out.printf("Forwarding %s:%d to %s:%d\n", fwdHost, fwdPort, host, 22);
        console.readLine();
    }
}
