package derivedIdentity;

import javax.persistence.*;


@Entity(name = "DictLabel")
//@MappedSuperclass
@IdClass(DictLabelId.class)
@Table(name = "dict_label_vw")
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="entity_dict_id",
		discriminatorType=DiscriminatorType.INTEGER)

public abstract class DictLabelEntity {
	@Basic(optional = false)
	@Column(name = "name", nullable = false)
	private String name;

	@Id
	@ManyToOne(cascade = {CascadeType.PERSIST,
		CascadeType.MERGE, CascadeType.REFRESH}, fetch = FetchType.LAZY,
		optional = false)
	@JoinColumn(name = "language_dict_id", nullable = false)
	private DictLanguageEntity language;

	@Id
	@Basic(optional = false)
	@Column(name = "entity_dict_id", nullable = false)
	private long entityRef;
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public DictLanguageEntity getLanguage() {
		return language;
	}
	
	public void setLanguage(DictLanguageEntity language) {
		this.language = language;
	}
	
	public long getEntityRef() {
		return entityRef;
	}
	
	public void setEntityRef(long entityRef) {
		this.entityRef = entityRef;
	}
}

