package derivedIdentity;

import javax.persistence.*;

@Entity(name = "DictLanguageLabel")
@IdClass(DictLanguageLabelId.class)
@DiscriminatorValue(value="1106")
public class DictLanguageLabelEntity extends DictLabelEntity {

	@Id
	@ManyToOne(cascade = {CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, 
		fetch = FetchType.LAZY, optional = false)
	@JoinColumn(name = "object_dict_id", nullable = false)
	private DictLanguageEntity forLanguage;
	
	public DictLanguageEntity getForLanguage() {
		return forLanguage;
	}
	
	public void setForLanguage(DictLanguageEntity forLanguage) {
		this.forLanguage = forLanguage;
	}
}