package derivedIdentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;

public class TestDict {

	EntityManagerFactoryImpl emf;
	protected List<String> sql = new ArrayList<String>();
	protected int sqlCount;
	public static HashMap props = null;

	public static void main(String[] args) throws Exception {
    	TestDict test = new TestDict();
        test.run(null);
    }

    public void run(EntityManagerFactory emf) throws Exception {
        boolean toClose = false;
        if (emf == null) {
            init();
            this.emf = (EntityManagerFactoryImpl) Persistence.createEntityManagerFactory(
                    "derivedIdentity", props);
            
            toClose = true;
        } else 
            this.emf = (EntityManagerFactoryImpl)emf;
        test();
        if (toClose) {
            for (String sqlStr : sql) {
                System.err.println(sqlStr);
            }
            this.emf.close();
        }
    }

    public List<String> getSql() {
        return sql;
    }

    public int getSqlCount() {
        return sqlCount;
    }

    public void init() {
        props = new HashMap(System.getProperties());
        props.put("openjpa.jdbc.JDBCListeners",
                new JDBCListener[] { this.new Listener() });
    }

    public void test() {
    	createObj();
    	queryObj();
    }
    
    public void createObj() {
		EntityManager em = emf.createEntityManager();
    	em.getTransaction().begin();
    	DictLanguageLabelEntity langLabel = new DictLanguageLabelEntity();
    	langLabel.setName("name");
    	langLabel.setEntityRef(1);
    	DictLanguageEntity forLanguage = new DictLanguageEntity();
    	forLanguage.setId(1);
    	langLabel.setForLanguage(forLanguage);
    	langLabel.setLanguage(forLanguage);
    	em.persist(langLabel);
    	em.persist(forLanguage);
    	em.flush();
    	em.getTransaction().commit();
    	em.close();
    	
    }
    
    public void queryObj() {
		EntityManager em = emf.createEntityManager();
		List<Library> list = em.createQuery("SELECT p FROM DictLanguageLabel p")
							   .getResultList();
		
		em.close();
    }
    
    
    public class Listener extends AbstractJDBCListener {
        @Override
        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL() != null && sql != null) {
                sql.add(event.getSQL());
                sqlCount++;
            }
        }
    }
    
}
