#include "Dispatcher.h"
#include <sys/time.h>

long now()
{
    timeval t;
    gettimeofday(&t, 0);
    return t.tv_sec;
}

Dispatcher::Dispatcher(Session& s) : 
    session(s), stopped(true), 
    prefetch(50), count(0), acked(0), maxAckDelay(30), ackFrequency(prefetch/2) {}

void Dispatcher::subscribe(const std::string& address, Callback callback)
{
    Receiver receiver = session.createReceiver(address);
    receiver.setCapacity(prefetch);
    callbacks[receiver.getName()] = callback;
}

void Dispatcher::dispatch()
{
    stopped = false;
    Receiver receiver;
    Message message;
    while (!stopped) {                
        if (session.nextReceiver(receiver, Duration::SECOND)
            && receiver.fetch(message, Duration::IMMEDIATE)) {
            callbacks[receiver.getName()](message);
            ++count;
        }
        if (count >= ackFrequency || (count && (now() - acked) >= maxAckDelay)) {
            session.acknowledge();
            acked = now();
            count = 0;
        }
    }
    session.acknowledge();
}

void Dispatcher::stop()
{
    stopped = true;
}
