#include <qpid/messaging/Connection.h>
#include <qpid/messaging/Message.h>
#include <qpid/messaging/Session.h>

#include <iostream>
#include <boost/bind.hpp>
#include "Dispatcher.h"

using namespace qpid::messaging;

class Handler
{
  public:
    Handler(Dispatcher&);
    void f1(Message&);
    void f2(Message&);
    void control(Message&);
  private:
    Dispatcher& dispatcher;
};

int main(int argc, char** argv)
{
    Connection connection("localhost:5672");
    try {
        connection.open();
        Session session = connection.createSession();
        Dispatcher dispatcher(session);
        Handler handler(dispatcher); 
        dispatcher.subscribe("queue-1", boost::bind(&Handler::f1, &handler, _1));
        dispatcher.subscribe("queue-2", boost::bind(&Handler::f2, &handler, _1));
        dispatcher.subscribe("amq.topic/shutdown", boost::bind(&Handler::control, &handler, _1));
        dispatcher.dispatch();
        session.close();            
        connection.close();
        return 0;
    } catch(const std::exception& error) {
        std::cout << error.what() << std::endl;
        connection.close();
    }
    return 1;   
}

Handler::Handler(Dispatcher& d) : dispatcher(d) {}

void Handler::f1(Message& message)
{
    std::cout << "f1: " << message.getContent() << std::endl;
}

void Handler::f2(Message& message)
{
    std::cout << "f2: " << message.getContent() << std::endl;
}

void Handler::control(Message& message)
{
    dispatcher.stop();
}
