#include <qpid/messaging/Connection.h>
#include <qpid/messaging/Message.h>
#include <qpid/messaging/Receiver.h>
#include <qpid/messaging/Session.h>

#include <boost/function.hpp>

using namespace qpid::messaging;

class Dispatcher
{
  public:
    typedef boost::function1<void, Message&> Callback;
    Dispatcher(Session&);
    void subscribe(const std::string& address, Callback);
    void dispatch();
    void stop();
  private:
    Session session;
    std::map<std::string, Callback> callbacks;
    volatile bool stopped;
    int prefetch;
    size_t count;
    long acked;
    long maxAckDelay;
    size_t ackFrequency;
};
