/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ru.pronto.wicketextras;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.util.tester.DummyHomePage;
import org.apache.wicket.util.tester.WicketTester;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/** @author Marat Radchenko */
public class StatelessCheckerTest {

  @StatelessComponent
  public static class StatelessPage extends DummyHomePage {
  }

  @StatelessComponent
  private static class StatelessLabel extends Label {
    public StatelessLabel(final String id) {
      super(id);
    }
  }

  private final StatelessChecker checker = new StatelessChecker();
  private WicketTester tester;

  @Test(expectedExceptions = IllegalArgumentException.class)
  public void nonBookmarkablePageTest() {
    this.tester.getApplication().addPostComponentOnBeforeRenderListener(this.checker);
    this.tester.startPage(StatelessPage.class);
  }

  @Test
  public void positiveTest() {
    this.tester.getApplication().addPostComponentOnBeforeRenderListener(this.checker);
    this.tester.startComponent(new StatelessLabel("foo"));
  }

  @BeforeMethod
  public void setUp() {
    this.tester = new WicketTester();
  }

  @AfterMethod
  public void tearDown() {
    this.tester.destroy();
  }
}
