/*
 * aplombee 2011
 * 
 */
package com.mycompany;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.push.IPushChannel;
import org.wicketstuff.push.IPushEventContext;
import org.wicketstuff.push.IPushEventHandler;
import org.wicketstuff.push.IPushNode;

/**
 *
 * @author Vineet Semwal
 * 
 */
public class ChatPage extends WebPage {

    String message, name, totalChat = "";
    Label displayChat;
    private static Logger logger = Logger.getLogger(ChatPage.class);

    public ChatPage() {

        WicketApplication app = (WicketApplication) WicketApplication.get();

        Component nodeHolder = new Label("nodeHolder");
        nodeHolder.setOutputMarkupPlaceholderTag(true);
        add(nodeHolder);


        IPushNode<String> chatNode = app.getTimerService().installNode(nodeHolder, new IPushEventHandler<String>() {

            public void onEvent(AjaxRequestTarget target, String event, IPushNode<String> node, IPushEventContext<String> ctx) {
                logger.info("got event " + event);
                totalChat = totalChat + "\n" + event;
                target.add(displayChat);
            }
        });
        app.getTimerService().connectToChannel(chatNode, app.getChannel());

        ChatForm chatForm = new ChatForm("chatForm");
        add(chatForm);

        displayChat = new Label("displayChat", new AbstractReadOnlyModel<String>() {

            @Override
            public String getObject() {
                return totalChat;
            }
        });
        displayChat.setOutputMarkupPlaceholderTag(true);
        add(displayChat);
    }

    class ChatForm extends Form<Void> {

        public ChatForm(String id) {
            super(id);
            TextField<String> nameField = new TextField<String>("nameField", new Model<String>() {

                @Override
                public String getObject() {
                    return name;
                }

                @Override
                public void setObject(String object) {
                    name = object;
                }
            });
            add(nameField);

            TextField<String> chatField = new TextField<String>("chatField", new Model<String>() {

                @Override
                public String getObject() {
                    return message;
                }

                @Override
                public void setObject(String object) {
                    message = object;
                }
            });
            add(chatField);


            AjaxButton submit = new AjaxButton("submit", this) {

                @Override
                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                  String  totalMessage = name + " : " + message;
                    logger.info("message sent=" + totalMessage);
                    WicketApplication app = (WicketApplication) WicketApplication.get();
                    app.getTimerService().publish(app.getChannel(), totalMessage);
                }

                @Override
                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    logger.error("inside onerr!");
                }
            };
            add(submit);


        }
    }
}
