package com.mycompany;

import org.apache.log4j.Logger;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.WebApplication;
import org.wicketstuff.push.IPushChannel;
import org.wicketstuff.push.IPushService;
import org.wicketstuff.push.timer.TimerPushService;

/**
 * Application object for your web application. If you want to run this application without deploying, run the Start class.
 * 
 * @see com.mycompany.Start#main(String[])
 */
public class WicketApplication extends WebApplication {

    private static Logger logger = Logger.getLogger(WicketApplication.class);

    /**
     * @see org.apache.wicket.Application#getHomePage()
     */
    @Override
    public Class<? extends Page> getHomePage() {
        return HomePage.class;
    }

    /**
     * @see org.apache.wicket.Application#init()
     */
    @Override
    public void init() {
        super.init();

        // add your configuration here
    }

    public IPushService getTimerService() {
        return TimerPushService.get();
    }

    public IPushChannel<String> getChannel() {
        if (channel == null) {

            channel = getTimerService().createChannel("channel");
            logger.info("channel created=" + channel);
        }
        return channel;
    }
    IPushChannel<String> channel;
}
