package com.mycompany;

import org.apache.wicket.Component;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;



public class HomePage extends WebPage {
	private static final long serialVersionUID = 1L;
	private String text;
	 private TextField<String>tf;
    public HomePage(final PageParameters parameters) {
	super(parameters);
    }
    @Override
    protected void onInitialize() {
    	super.onInitialize();
    	IModel<String>model=new Model<String>(){
    		@Override
    		public String getObject() {
    		return text;
    		}
    		@Override
    		public void setObject(String object) {
    	         text=object;
    		}
    	};
    TextField<String>tf=new TextField<String>("tf",model );
    tf.add(new TestBehavior());
    tf.setMarkupId(tf.getId());
    add(tf);
    }
    @Override
    public void renderHead(IHeaderResponse response) {
       	super.renderHead(response);
       	response.render(JavaScriptHeaderItem.forReference(new PackageResourceReference(HomePage.class, "test.js")));
    }
    public class TestBehavior extends AjaxFormComponentUpdatingBehavior {
		private static final long serialVersionUID = 1L;

		public TestBehavior() {
			super("onkeyup");
		}
		@Override
		protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
			super.updateAjaxAttributes(attributes);
		AjaxCallListener listener=new AjaxCallListener(){
			@Override
			public CharSequence getBeforeHandler(Component component) {
			super.getBeforeHandler(component);
			String call=String.format("acall('%s','%s')", component.getMarkupId() ,TestBehavior.this.getCallbackUrl());
			return  call+" ;";
			}
		};
		attributes.getAjaxCallListeners().add(listener);
		}

		@Override
		protected void onUpdate(AjaxRequestTarget target) {
			String val = RequestCycle.get().getRequest().getRequestParameters().getParameterValue(tf.getMarkupId()).toString();
			System.out.println("value retrieved from js=" + val);
		}		

	}
    
    
}
