/* 
 * image proces library
 * made by anders Gnistrup
 *--------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
/* includes needed for openCV library */
#include <ipl.h>
#include "piclib.h"


/* 
 * abstract :
 * low pass filter. This funktion finds the mean from a 
 * cell of size sice "size" in src_pic and insert the 
 * value in dst_pic.
 * Input  : src and dst picture, and size of the square.
 * Output : 0 on succes and data is insert in picture dst_pic.
 *          -1 on failure.
 *-------------------------------------------------------------*/
int mean_pic(pic_struct *src_pic,pic_struct *dst_pic, int register size) {
  unsigned char *dst_ptr, *src_ptr;
  unsigned char register *pdx;
  unsigned int register value;
  int px,py;
  int register pdy,i;
  int register width, height;

  if(src_pic==NULL || dst_pic==NULL) return -EFAULT;
  if(src_pic->pic_ptr==NULL || dst_pic->pic_ptr==NULL) return -EFAULT;
  if(size>=src_pic->height || size>=src_pic->width) return -EINVAL;
  
  /* start the routine */
  src_ptr = src_pic->pic_ptr;
  dst_ptr = dst_pic->pic_ptr;
  width = src_pic->width;
  height = src_pic->height;

  for(py=size;py<height-size;py++) {
    for(px=size;px<width-size;px++){
      value = 0;
      pdx = src_ptr + (px-size) + py * width; 
      for(pdy=-size; pdy<=size; pdy++) {
	pdx += pdy * width;
	for(i=-size; i<=size; i++) {
	  value += *pdx++;
	}
	pdx -= size*2 + 1;
      }
      *(dst_ptr + px + py * width) = (value/9);
    }
  }  
  return 0;
}  

