#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <linux/videodev.h>
#include <stdlib.h> 
#include <unistd.h>
#include <errno.h>
#include <math.h>
#include <pthread.h>

/* includes needed for openCV library */
#include <ipl.h>
#include <cv.h>
#include <cvtypes.h>
#include <cvvis.h>
#include <asm/timex.h>       
#include "piclib.h"

#define NR_PICT 10
#define WIDTH 320
#define HEIGHT 240


/* physical dim os chessboard */
#define TABLE_HEIGHT 1.090 /* cm */
#define CHESS_WIDTH 0.178   /* cm */
#define CHESS_SIZE  5      /* number af squar in x ore y*/ 
#define CHESS_SQR 25       /* total number af squars */
#define CHESS_START 0.109   /* dist from rot point in cm */
#define CHESS_TRANS 0.015    /* trans ins cm */
#define SQR_SIZE CHESS_WIDTH/((float) CHESS_SIZE)      
#define PHI M_PI

static int makeEstimate(int,CvSize,CvVect32f,CvMatr32f,IplImage *,IplImage *); 
static int saveEstimate(char *,CvVect32f,CvMatr32f);
static int loadEstimate(char *,CvVect32f,CvMatr32f);
static int PrintEstimate(CvVect32f matric,CvMatr32f Vect);
static int makeSpotTrack(void);
static int getMoments(IplImage *IplImg, register double *values);
static int calcMoments(IplImage *,int,int,double *); 
static int isCircle(double* moments, double*);


typedef struct data_ {
  pthread_mutex_t mutex;
  pthread_cond_t cond;
  IplImage *ipl_src[2];
  IplImage *ipl_dst[2];
  CvMatr32f cameraMatrix; /* just a pointer */
  CvVect32f cameraVektor; /* just a pointer */
  CvPoint pos;
  int run;
} data;

static data local_data = {PTHREAD_MUTEX_INITIALIZER,
			  PTHREAD_COND_INITIALIZER};

int main(void) {
  char name[] = "/dev/video0";
  IplImage *ipl_pic,*ipl_tmp;
  CvSize ipl_size = {WIDTH,HEIGHT};
  CvMatr32f cameraMatrix; /* just a pointer */
  CvVect32f cameraVektor; /* just a pointer */
  int res;
  char fname[20];

  /* init structures */
  ipl_tmp = cvCreateImage(ipl_size,IPL_DEPTH_8U,1);
  ipl_pic = cvCreateImage(ipl_size,IPL_DEPTH_8U,1);
 
  if(open_video(ipl_pic,EVEN,name)!=0) {
    printf("error open dev %s\n",name);
    return -1;;
  }
  /* alocate mem for cameraVektor and cameraMatrix */
  cameraVektor = calloc(4,sizeof(float));
  cameraMatrix = calloc(9,sizeof(float));
  
  /* make or load estiamte */
  printf("enter new for new estimate or enter file to load :");
  scanf("%s",fname);
  if(strcmp(fname,"new") == 0) {
    do {
      res = makeEstimate(5,ipl_size,cameraVektor,cameraMatrix,ipl_pic,ipl_tmp);
      printf("Enter name of file to save (max 20 chars):");
      scanf("%s",fname);
      saveEstimate(fname,cameraMatrix,cameraVektor);
    } while (res!=0); 
  } 
  else {
    do {
      res = loadEstimate(fname,cameraMatrix,cameraVektor);
      if(res!=0) {
	printf("error open file\nEnter again");
	scanf("%s",fname);
      }
    } while (res!=0); 
  }
  cvReleaseImage(&ipl_pic);
  cvReleaseImage(&ipl_tmp);
  
  PrintEstimate(cameraMatrix,cameraVektor);
  local_data.cameraMatrix = cameraMatrix;
  local_data.cameraVektor = cameraVektor;
  
  printf("now for the white spot traking\n");
  /* first make memmory */
  local_data.ipl_src[0] = cvCreateImage(ipl_size,IPL_DEPTH_8U,1);
  local_data.ipl_src[0]->origin = IPL_ORIGIN_TL;
  local_data.ipl_src[1] = cvCreateImage(ipl_size,IPL_DEPTH_8U,1);
  local_data.ipl_src[1]->origin = IPL_ORIGIN_TL;
  local_data.ipl_dst[0] = cvCreateImage(ipl_size,IPL_DEPTH_8U,1);
  local_data.ipl_dst[0]->origin = IPL_ORIGIN_TL;
  local_data.ipl_dst[1] = cvCreateImage(ipl_size,IPL_DEPTH_8U,1);
  local_data.ipl_dst[1]->origin = IPL_ORIGIN_TL;
  
  makeSpotTrack();
  close_video();
  cvReleaseImage(&local_data.ipl_src[0]);
  cvReleaseImage(&local_data.ipl_src[1]);
  cvReleaseImage(&local_data.ipl_dst[0]);
  cvReleaseImage(&local_data.ipl_dst[1]);
  return 0;
}

#define MAX_PICTURE 20
static int makeEstimate(int nr_images,CvSize img_size, 
			CvVect32f distortion, CvMatr32f cameraMatrix32f,
			IplImage *ipl_pic,IplImage *ipl_tmp) {
  int corn[MAX_PICTURE],res,*corn_ptr;
  CvPoint2D32f corners[MAX_PICTURE*CHESS_SQR],*corners_ptr;
  CvSize board = { CHESS_SIZE, CHESS_SIZE };
  CvPoint3D32f chessBoard[CHESS_SQR*MAX_PICTURE];
  float TransVect_[3*MAX_PICTURE];
  float RotMatrc_[9*MAX_PICTURE];
  CvVect32f TransVect; 
  CvMatr32f RotMatrc; 
  int i,j,k;
  char fname[] = "pic0";

  if(nr_images>MAX_PICTURE) return -EINVAL; 
  
  /* init stuff */
  for(k=0;k<MAX_PICTURE;k++) {
    for(i=0;i<CHESS_SIZE;i++) {
      for(j=0;j<CHESS_SIZE;j++) {
	chessBoard[k*CHESS_SQR + i*CHESS_SIZE + j].x = j*SQR_SIZE;
	chessBoard[k*CHESS_SQR + i*CHESS_SIZE + j].y = i*SQR_SIZE;
	chessBoard[k*CHESS_SQR + i*CHESS_SIZE + j].z = 0;
      }
    }
  }
  TransVect= TransVect_;
  RotMatrc = RotMatrc_;
  corn_ptr = corn;
  corners_ptr = corners;

  for(i=0;i<nr_images;i++) {
    getchar();
    printf("get picture\n");
    get_pic(ipl_pic,EVEN);
    *corn_ptr = CHESS_SQR;
    res = cvFindChessBoardCornerGuesses(ipl_pic,ipl_tmp,NULL, 
					board,
					corners_ptr,
					corn_ptr);
    if(res != 1) {
      printf("did not get chessboard got %d\n",*corn_ptr);
      printf("try move board\n");
      i--;
    }
    else {
      pic2file(ipl_pic,fname);
      fname[3]++;
      corn_ptr++;
      corners_ptr += CHESS_SQR;
    }
  }
  
  /* calculate the estimate 
   * numImages       : nr_images 
   * numPoints       : CHESS_SQR
   * imageSize       : img_size int i;
   * imagePoints32f  : corners from cvFindChess....
   * objectPoint32f  : dimensions of the chess board
   * distortion32f   : output
   * camaraMatrix32f : output
   * transVects32f   : output pointer transformation vektor
   * rotMatrs32f     : output rotation matrix
   * useIntrinsicGuess : 0;
   */

  cvCalibrateCamera(nr_images,
		    corn,
		    img_size,
		    corners,    
		    chessBoard,
		    distortion,
		    cameraMatrix32f,
		    TransVect,
		    RotMatrc,
		    0);
  get_pic(ipl_pic,EVEN);
  pic2file(ipl_pic,"ref");
  
  cvUnDistortOnce(ipl_pic,
		  ipl_tmp,
		  cameraMatrix32f,
		  distortion,0);
  pic2file(ipl_tmp,"estimate");
  printf("end Make estimate\n");
  /* test */
  return 0;
}

static int saveEstimate(char *fname,CvVect32f matric,CvMatr32f Vect) {
  FILE *file_ptr;
  float data[9+4],*data_ptr;
  int i;
  
  printf("got %s\n",fname);
  data_ptr = data;
  for(i=0;i<9;i++) 
    *data_ptr++ = *matric++;
  for(i=0;i<4;i++) 
    *data_ptr++ = *Vect++;
  
  if( (file_ptr = fopen(fname,"w")) == NULL) {
    printf("error open file\n");
    return -EIO;
  }
  
  if(fwrite(data,sizeof(float),13,file_ptr)!=13) {
    printf("error writing file\n");
    return -EIO;
  }

  fclose(file_ptr);
  return 0;
}

static int loadEstimate(char *fname,CvVect32f matric,CvMatr32f Vect) {
  FILE *file_ptr;
  float data[9+4],*data_ptr;
  int i;
  
  if( (file_ptr = fopen(fname,"r")) == NULL) {
    printf("error open file\n");
    return -EIO;
  }
  if(fread(data,sizeof(float),13,file_ptr) != 13) {
    printf("error reading\n");
    return -EIO;
  }
  fclose(file_ptr);
  
  data_ptr = data;
  for(i=0;i<9;i++) 
    *matric++ = *data_ptr++;
  for(i=0;i<4;i++) 
    *Vect++ = *data_ptr++;
  return 0;
} 

static int PrintEstimate(CvVect32f matric,CvMatr32f Vect) {
  int i,j;

  printf("Vektor : ");
  for(i=0;i<4;i++)
    printf(" %f ",*Vect++);
  printf("\n");
  printf("Matric :\n"); 
  for(i=0;i<3;i++) {
    for(j=0;j<3;j++) {
      printf(" %f ",*matric++);
    }
    printf("\n");
  }
  return 0;
}
    
/* 
 * spot tracking 
 *----------------*/
void *thread_spot(void *arg);
static int makeSpotTrack(void) {
  char ch[9];
  int res;
  int stop;
  pthread_t thread;
  local_data.run = 0;
  stop = 1;
  do {
    printf("enter S for stop whitespot tracking\n");
    printf("enter R for run whitespot tracking\n");
    printf("enter P for Print whitespot tracking position\n");
    if(scanf("%s",ch)==0) printf("??????????");
    switch(ch[0]) {
    case 's':
    case 'S':
      printf("stop whitespot tracking\n");
      if(local_data.run == 1) {
	local_data.run = 0;
	res = pthread_join(thread, NULL);
	printf("stopped and recived %d\n",res);
      }
      stop = 0;
      break;
    case 'R':
    case 'r':
      if(local_data.run == 0) {
	local_data.run = 1;
	printf("starting thread\n");
	res = pthread_create(&thread, NULL,thread_spot,NULL);
      }
      printf("start whitespot tracking\n");
      break;
    case 'P':
    case 'p':
      pthread_mutex_lock(&local_data.mutex);
      pthread_cond_wait(&local_data.cond,&local_data.mutex);
      printf("print whitespot position : (%d,%d)\n",
	     local_data.pos.x,
	     local_data.pos.y);
      pthread_mutex_unlock(&local_data.mutex);
      break;
    default:
      printf("wrong command\n");
      break;
    }
  } while(stop == 1);
  printf("end makeSpotTrak\n");
  return 0;
}

typedef struct {
  CvPoint pos;
  double mom2mom, m00;
} object;

#define MAX_ERROR 0.1
#define MAX_ERROR_MOM 2
#define OBJECT_SIZE 25
void *thread_spot(void *arg) {

  object best;
  IplROI roi_cap = {0,0,0,WIDTH,HEIGHT};
  CvMemStorage *storage;
  double meanVal;
  int pic_nr=0,prev;
  int i = 1,j=0;
  char fname[] = "test0";
  double moment[6],error;
 
  printf("start thread_spot\n");
  /* THIS IS AS DYNAMIC AS IT CAN BE */
  storage = cvCreateMemStorage(0);

  /* set roi for pixture */
  while(local_data.run == 1) {
    /* get picture */
    prev = pic_nr;
    pic_nr++;
    pic_nr &= 0x1;
    get_pic(local_data.ipl_src[pic_nr],EVEN);
    
    /* do the analysis on a half of picture*/
    cvUnDistortOnce(local_data.ipl_src[pic_nr],
		    local_data.ipl_dst[0],
		    local_data.cameraMatrix,
		    local_data.cameraVektor,0);
    if (i++<10) {
      fname[4]++;
      pic2file(local_data.ipl_dst[0],fname);
    }
    local_data.ipl_dst[0]->roi = &roi_cap;
    local_data.ipl_dst[1]->roi = &roi_cap;
    meanVal = cvMean(local_data.ipl_dst[0],NULL)/2;
  
    cvThreshold(local_data.ipl_dst[0],local_data.ipl_dst[1],
		meanVal,255,CV_THRESH_BINARY_INV); 
 
 
    if (i++<10) {
      fname[4]++;
      pic2file(local_data.ipl_dst[1],fname);
    }
    best.mom2mom = MAX_ERROR_MOM;
 
    while(getMoments(local_data.ipl_dst[1], moment)==0) {
      error = MAX_ERROR;
      if(isCircle(moment,&error)==0) {
	/* find the best circle */
	if(error<best.mom2mom) {
	  best.mom2mom = error;
	  best.pos.x = moment[0];
	  best.pos.y = moment[1];
	}
      }
    }
    if(best.mom2mom < MAX_ERROR_MOM) {
      printf("found circle at pos (%d,%d) with error %f \n",
	     best.pos.x,best.pos.y,best.mom2mom);
      pthread_mutex_lock(&local_data.mutex); 
      local_data.pos.x = best.pos.x;
      local_data.pos.y = best.pos.y;
      pthread_cond_signal(&local_data.cond);
      pthread_mutex_unlock(&local_data.mutex);
      /* set roi */ 
      /* x  */
      roi_cap.xOffset = ( (best.pos.x - OBJECT_SIZE) > 0) ? best.pos.x - OBJECT_SIZE : 0;
      roi_cap.width   = ( (roi_cap.xOffset + 2*OBJECT_SIZE) < WIDTH) ? 
	2*OBJECT_SIZE : local_data.ipl_dst[1]->width - roi_cap.xOffset;
      /* y */
      roi_cap.yOffset = ( (best.pos.y - OBJECT_SIZE) > 0) ? best.pos.y - OBJECT_SIZE : 0;
      roi_cap.height  = ( (roi_cap.yOffset + 2*OBJECT_SIZE) < local_data.ipl_dst[1]->height) ? 
	2*OBJECT_SIZE : local_data.ipl_dst[1]->height - roi_cap.yOffset;  
    }
    else {
      /* exspand roi */
      pthread_mutex_lock(&local_data.mutex); 
      local_data.pos.x = -1;
      local_data.pos.y = -1;
      pthread_cond_broadcast(&local_data.cond);
      pthread_mutex_unlock(&local_data.mutex);
      roi_cap.xOffset = 0;
      roi_cap.yOffset = 0;
      roi_cap.width   = WIDTH;
      roi_cap.height  = HEIGHT;
    }
    local_data.ipl_dst[0]->roi = NULL;
    local_data.ipl_dst[1]->roi = NULL;
  }
  printf("end thread_spot\n");
  return 0;
}

/*
 * funktion that calculates 0, 11 and 2 moments for first found
 * object in ROI. 
 * The funktion is recrusive, wish means that *values have to
 * be set to Zero. This olso means that is ROI contains 2 or 
 * more objects the next can be found by runnnig funktion once 
 * more. 
 *----------------------------------------------------------*/
static int getMoments(IplImage *IplImg, register double *values) {
  int i,j,res;
  double mb[6],x_tilte,y_tilte;
  unsigned char *roi_ptr;
  int x_off,y_off,width,height;
  int point_found;
  /* find a pixel != 0 in RIO*/
  /* init ROI */
  roi_ptr = IplImg->imageData;
  if(IplImg->roi==NULL) {
    x_off  = 0;
    y_off  = 0;
    width  = IplImg->width;
    height = IplImg->height;
  }
  else {
    x_off  = IplImg->roi->xOffset;
    y_off  = IplImg->roi->yOffset;
    width  = IplImg->roi->width;
    height = IplImg->roi->height; 
  }
  roi_ptr += x_off + y_off * IplImg->widthStep;
  point_found = 0;
  for(i=0;i<height;i++) {
    for(j=0;j<width;j++) {
      if(*(roi_ptr+j+i*IplImg->widthStep) > 50) { /* 50 -> Just a threadshold. could be any value 0-254*/  
	/* point found */
	width  = x_off + j;
	height = y_off + i;
	j = width;
	i = height;
	point_found = 1;
      }
    }
  }
  if(point_found == 0) return -1; 
  for(i=0;i<6;i++) mb[i] = 0;
  res = calcMoments(IplImg,height,width,mb);
  if(res==0) {
    x_tilte     = mb[1]/mb[0];
    y_tilte     = mb[2]/mb[0];
    *(values  ) = x_tilte;                             /* x_tilte */
    *(values+1) = y_tilte;                             /* y_tilte */
    *(values+2) = mb[0];                               /* arear */
    *(values+3) = mb[3] - x_tilte*y_tilte*mb[0];       /* 11'end moment xy */
    *(values+4) = mb[4] - x_tilte*mb[1];               /* 2'end moment x   */  
    *(values+5) = mb[5] - y_tilte*mb[2];               /* 2'end moment y   */ 
  }
  return res;
}

/* values = {m00,m10,m01,m11,m20,m02} */
static int calcMoments(IplImage *IplImg,int height, int width, double *values) {
  unsigned char *pic_ptr;
  int value;
  int boarders = 0;
  
  pic_ptr = IplImg->imageData + width + IplImg->widthStep*height; 
  /* alter structure */
  value = (*pic_ptr > 0) ? 1 : 0;
  if(value==1) {
    *pic_ptr = 0;
    *(values + 0) += 1;
    *(values + 1) += width;             /* 1 moment around x = 0 */
    *(values + 2) += height;            /* 1 moment around y = 0 */
    *(values + 3) += height*width; /* moment moment around x = 0, y = 0 */
    *(values + 4) += width*width;      /* 2 moment around x */
    *(values + 5) += height*height;     /* 2 moment around y */
    
    if(width==0)                   boarders += 0x1; /* left */
    if(width==(IplImg->width-1))   boarders += 0x2; /* right */
    if(height== 0)                 boarders += 0x4; /* top */
    if(height==(IplImg->height-1)) boarders += 0x8; /* boddum */
    switch(boarders) {
    case 0:
      /* in picture */
      calcMoments(IplImg,height-1,width-1 , values);
      calcMoments(IplImg,height-1,width, values);
      calcMoments(IplImg,height-1,width+1, values);
      calcMoments(IplImg,height,width-1, values);
      calcMoments(IplImg,height,width+1, values);
      calcMoments(IplImg,height+1,width-1, values);
      calcMoments(IplImg,height+1,width, values);
      calcMoments(IplImg,height+1,width+1, values);
      break;
    case 0x1:
      /* on left boarder */
      calcMoments(IplImg,height-1,width, values);
      calcMoments(IplImg,height-1,width+1, values);
      calcMoments(IplImg,height,width+1, values);
      calcMoments(IplImg,height+1,width, values);
      calcMoments(IplImg,height+1,width+1, values);
      break;
    case 0x2:
      /* on right boarder */
      calcMoments(IplImg,height-1,width-1, values);
      calcMoments(IplImg,height-1,width, values);
      calcMoments(IplImg,height,width-1, values);
      calcMoments(IplImg,height+1,width-1, values);
      calcMoments(IplImg,height+1,width, values);
      break;
    case 0x4:
      /* on top border */
      calcMoments(IplImg,height,width-1, values);
      calcMoments(IplImg,height,width+1, values);
      calcMoments(IplImg,height+1,width-1, values);
      calcMoments(IplImg,height+1,width, values);
      calcMoments(IplImg,height+1,width+1, values);
      break;
    case 0x8:
      /* on boddum boarder */
      calcMoments(IplImg,height-1,width-1, values);
      calcMoments(IplImg,height-1,width, values);
      calcMoments(IplImg,height-1,width+1, values);
      calcMoments(IplImg,height,width-1, values);
      calcMoments(IplImg,height,width+1, values);
      break;
    case (0x1|0x4):
      /* left and top boarder */
      calcMoments(IplImg,height,width+1, values);
      calcMoments(IplImg,height+1,width, values);
      calcMoments(IplImg,height+1,width+1, values);
      break;
    case (0x1|0x8):
      /* left and boddum border */
      calcMoments(IplImg,height-1,width, values);
      calcMoments(IplImg,height,width-1, values);
      calcMoments(IplImg,height,width+1, values);
      break;
    case (0x2|0x4):
      /* on right and top boarder */
      calcMoments(IplImg,height,width-1, values);
      calcMoments(IplImg,height+1,width, values);
      calcMoments(IplImg,height+1,width-1, values);
      break; 
    case (0x2|0x8):
      /* on right and boddum boarder */
      calcMoments(IplImg,height,width-1, values);
      calcMoments(IplImg,height-1,width, values);
      calcMoments(IplImg,height-1,width-1, values);
      break;  
    } 
  }
  return 0;
}
  
/* 
 * funktion used to test if a objekt is a 
 * circle. 
 * input x_pos,y_pos,m00,m11,m20,m02
 *-----------------------------------------*/
static int isCircle(double* moments, double *mError) { 
  double Emax,Emin,Areal,angle;
  double 
    m00 = *(moments+2),
    m11 = 2.0* *(moments+3),
    m20 = *(moments+4),
    m02 = *(moments+5);
  
  /* test for small arear */
  if(m00<50) return -1;
    
    
  
  /* it does not matter if max shiftet min */ 
  if(m20==m02) 
    angle = PHI/4; /* (phi/2/)2 */ 
  else if(m11==0) 
    angle = 0;
  else
    angle = atan(m11/(m20-m02))/2;
  
  
  Emax = 0.5*(m20+m02) + 0.5*(m20-m02)*cos(2*angle) 
    + 0.5*m11*sin(2*angle);
  Emin = 0.5*(m20+m02) - 0.5*(m20-m02)*cos(2*angle) - 
    0.5*m11*sin(2*angle);
  
  /* calculate error and test */ 
  Areal = sqrt(sqrt(Emax*Emin)*4*PHI)/m00;
  Areal = (Areal >= 1) ? Areal : 1/Areal;
  Areal = (Areal - 1)*100;
  
  if ( Areal > *mError) 
    return -1;
  Areal = Emax/Emin;
  Areal = (Areal >= 1) ? Areal : 1/Areal;
  *mError = sqrt(Areal);
  return 0;
}
  
    
    
	
  











  
