"
" Author: Olaf Dabrunz
" Year: 2015
"

set nocompatible

" VIM_TESTOPTS="errmode=stop, testcnt=1000, d_size=10000, d2_size=10000, d2_start=1, d_val_expr='t'.i, d2_val_expr='t'.i, use_same_dict=0, do_copy=0, do_test=1"

0put =$TEST_TITLE | redraw
1put ='vim''s PID: '.getpid()

let opts = {
            \   'errmode':      'stop',
            \   'ifence_fact':  1.2,
            \   'testnum':      3,
            \   'testcnt':      1000,
            \   'd_size':       10000,
            \   'd2_size':      10000,
            \   'd_start':      1,
            \   'd2_start':     1,
            \   'd_val_expr':   '''t''.i',
            \   'd2_val_expr':  '''t''.i',
            \   'use_same_dict': 0,
            \   'do_copy':      0,
            \   'do_test':      1,
            \   'do_oh_test':   0,
            \   'measure_separately':   0,
            \ }

for opt in split($VIM_TESTOPTS, '\(\s*,\s*\|\s\+\)')
    let [k; v] = split(opt, '\s*=\s*')
    let opts[k] = empty(v) ? 1 : v[0]
endfor
let opts.ifence_fact = type(opts.ifence_fact) == type(1.0)
            \ ? opts.ifence_fact : str2float(opts.ifence_fact)

let ostr = ''
for k in sort(keys(opts))
    let ostr .= ' '.string(k).': '
                \ .(type(opts[k]) == type(1.0) ? string(opts[k]) : opts[k])
endfor
$put =ostr

func! FloatCmp(i1, i2)
    return a:i1 == a:i2 ? 0 : a:i1 > a:i2 ? 1 : -1
endfunc

func! Median(s)
    if len(a:s) == 0 | return 0 | endif

    let hlen = len(a:s) / 2
    return len(a:s) % 2
                \ ? [a:s[hlen], a:s[0:hlen-1], a:s[hlen+1:-1]]
                \ : [(a:s[hlen-1] + a:s[hlen]) / 2, a:s[0:hlen-1], a:s[hlen :-1]]
endfunc

func! RemoveOutliers(ti)
    " compute outliers
    call sort(a:ti, 'FloatCmp')
    let [q2, lrange, hrange] = Median(a:ti)
    let [q1; r] = Median(lrange)
    let [q3; r] = Median(hrange)
    let iqr = q3 - q1
    let [ifd, ofd] = [iqr * g:opts.ifence_fact, iqr * g:opts.ifence_fact * 2]
    let [lif, hif] = [q1 - ifd, q3 + ifd]
    let [lof, hof] = [q1 - ofd, q3 + ofd]

    let tic = copy(a:ti)

    " remove outliers outside of outer fences
"    call filter(a:ti, 'v:val >= lof && v:val <= hof')

    " remove outliers outside of inner fences
    $put ='outlier removal: inner fences: '.string([lif, hif])
    call filter(a:ti, 'v:val >= lif && v:val <= hif')

    for val in tic
        if index(a:ti, val) != -1 | continue | endif
        $put ='removed outlier: '.string(val)
    endfor
endfunc

func! Variance(ti)
   if len(a:ti) == 0 | return 0 | endif

   let k = a:ti[0]
   let n = 0
   let sum = 0
   let sum_sqr = 0
   for x in a:ti
       let sum += x - k
       let sum_sqr += (x - k) * (x - k)
   endfor

   let var = sum_sqr - ((sum * sum) / len(a:ti))
   let var = var / len(a:ti)
   return var
endfunc

func! AppendSecs(start)
    $delete
    let str = @"[0:-2] .' '. reltimestr(reltime(a:start)) .' seconds'
    $put =str
    redraw
endfunc


let testcnt = opts.testcnt
let errmode = opts.errmode
let do_copy = opts.do_copy
let do_oh_test = opts.do_oh_test
let use_same = opts.use_same_dict
let measure_separately = opts.measure_separately

if use_same
    let d_end   = opts.d_start + opts.d_size - 1
    $put ='creating dict d ('.opts.d_size.' items) ...' | redraw
    let start = reltime()
    let d = {}  | for i in range(opts.d_start, d_end)   | let d[i] = eval(opts.d_val_expr)  | endfor
    call AppendSecs(start)
    let d2 = {}
    let overlap_pc = (d_end - opts.d_start + 1) * 100 / opts.d_size
else
    let d_end   = opts.d_start + opts.d_size - 1
    let d2_end  = opts.d2_start + opts.d2_size - 1
    $put ='creating dict d ('.opts.d_size.' items) ...' | redraw
    let start = reltime()
    let d = {}  | for i in range(opts.d_start, d_end)   | let d[i] = eval(opts.d_val_expr)  | endfor
    call AppendSecs(start)
    $put ='creating dict d2 ('.opts.d2_size.' items) ...' | redraw
    let start = reltime()
    let d2 = {} | for i in range(opts.d2_start, d2_end) | let d2[i] = eval(opts.d_val_expr) | endfor
    call AppendSecs(start)
    let overlap_pc = (min([d_end, d2_end]) - max([opts.d_start, opts.d2_start]) + 1) * 100 / opts.d2_size
endif

let cp_avg = 0
if do_copy && !measure_separately
    $put ='measuring copy(d) overhead ...' | redraw
    let ti = []
    for t in range(opts.testnum)
        let start = reltime()
        for i in range(testcnt) | let dc = copy(d) | endfor
        let ti += [str2float(reltimestr(reltime(start)))]
        $put ='copy(d) ('.testcnt
                    \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.'))'
                    \ .': '.string(ti[-1])
        redraw
    endfor

    call RemoveOutliers(ti)
    exe 'let sum = ' . join(ti, '+')
    let cp_avg = sum / len(ti)

    $put ='copy(d) (avg of '.string(len(ti)).' tests: '.testcnt.' times, '
                \ .len(d).' size dict d): '.string(cp_avg)
    redraw
endif

let has_errmode_param = 1
try
    call extend({}, {}, 'force', 'stop')
catch /^Vim(\a\+):E118:/
    let has_errmode_param = 0
    if errmode == 'rollback'
        " add a locked item to trigger the lock check loop
        let d.l = 1
        lockvar d.l
    endif
endtry

if opts.do_test && !measure_separately && has_errmode_param
    if use_same && do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                let dc = copy(d)
                if !do_oh_test
                    call extend(dc, dc, 'force', errmode)
                endif
            endfor
            let p = str2float(reltimestr(reltime(start)))
            let ti += [p - cp_avg]
            $put ='copy(d), extend(dc, dc, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(p)
                        \ .' (- '.string(cp_avg).' =) '.string(ti[-1])
        endfunc
    elseif use_same
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                if !do_oh_test
                    call extend(d, d, 'force', errmode)
                endif
            endfor
            let ti += [str2float(reltimestr(reltime(start)))]
            $put ='extend(d, d, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(ti[-1])
        endfunc
    elseif do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                let dc = copy(d)
                if !do_oh_test
                    call extend(dc, d2, 'force', errmode)
                endif
            endfor
            let p = str2float(reltimestr(reltime(start)))
            let ti += [p - cp_avg]
            $put ='copy(d), extend(dc, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(p)
                        \ .' (- '.string(cp_avg).' =) '.string(ti[-1])
        endfunc
    else
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                if !do_oh_test
                    call extend(d, d2, 'force', errmode)
                endif
            endfor
            let ti += [str2float(reltimestr(reltime(start)))]
            $put ='extend(d, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(ti[-1])
        endfunc
    endif

elseif opts.do_test && measure_separately && has_errmode_param
    if use_same && do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let dc = copy(d)
                let start = reltime()
                if !do_oh_test
                    call extend(dc, dc, 'force', errmode)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(dc, dc, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(ti[-1])
        endfunc
    elseif use_same
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let start = reltime()
                if !do_oh_test
                    call extend(d, d, 'force', errmode)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(d, d, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(ti[-1])
        endfunc
    elseif do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let dc = copy(d)
                let start = reltime()
                if !do_oh_test
                    call extend(dc, d2, 'force', errmode)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(dc, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(ti[-1])
        endfunc
    else
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let start = reltime()
                if !do_oh_test
                    call extend(d, d2, 'force', errmode)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(d, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(ti[-1])
        endfunc
    endif

elseif opts.do_test && !measure_separately && !has_errmode_param
    if use_same && do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                let dc = copy(d)
                if errmode == 'rollback'
                    lockvar dc.l
                endif
                if !do_oh_test
                    call extend(dc, dc)
                endif
            endfor
            let p = str2float(reltimestr(reltime(start)))
            let ti += [p - cp_avg]
            $put ='copy(d), extend(dc, dc, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(p)
                        \ .' (- '.string(cp_avg).' =) '.string(ti[-1])
        endfunc
    elseif use_same
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                if !do_oh_test
                    call extend(d, d)
                endif
            endfor
            let ti += [str2float(reltimestr(reltime(start)))]
            $put ='extend(d, d, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(ti[-1])
        endfunc
    elseif do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                let dc = copy(d)
                if errmode == 'rollback'
                    lockvar dc.l
                endif
                if !do_oh_test
                    call extend(dc, d2)
                endif
            endfor
            let p = str2float(reltimestr(reltime(start)))
            let ti += [p - cp_avg]
            $put ='copy(d), extend(dc, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(p)
                        \ .' (- '.string(cp_avg).' =) '.string(ti[-1])
        endfunc
    else
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            for i in range(testcnt)
                if !do_oh_test
                    call extend(d, d2)
                endif
            endfor
            let ti += [str2float(reltimestr(reltime(start)))]
            $put ='extend(d, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(ti[-1])
        endfunc
    endif

elseif opts.do_test && measure_separately && !has_errmode_param
    if use_same && do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let dc = copy(d)
                if errmode == 'rollback'
                    lockvar dc.l
                endif
                let start = reltime()
                if !do_oh_test
                    call extend(dc, dc)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(dc, dc, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(ti[-1])
        endfunc
    elseif use_same
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let start = reltime()
                if !do_oh_test
                    call extend(d, d)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(d, d, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .': '.string(ti[-1])
        endfunc
    elseif do_copy
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let dc = copy(d)
                if errmode == 'rollback'
                    lockvar dc.l
                endif
                let start = reltime()
                if !do_oh_test
                    call extend(dc, d2)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(dc, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(ti[-1])
        endfunc
    else
        func Testloop()
            let [ti, testcnt, d, d2, errmode, start, cp_avg, opts, do_oh_test, overlap_pc] =
                        \ [g:ti, g:testcnt, g:d, g:d2, g:errmode, g:start, g:cp_avg,
                        \ g:opts, g:do_oh_test, g:overlap_pc]
            let tsum = 0.0
            for i in range(testcnt)
                let start = reltime()
                if !do_oh_test
                    call extend(d, d2)
                endif
                let tsum += str2float(reltimestr(reltime(start)))
            endfor
            let ti += [tsum]
            $put ='extend(d, d2, ''force'', '''.errmode.''') ('.testcnt
                        \ .' times, '.len(d).' size dict d (init: '.opts.d_val_expr.')'
                        \ .', '.len(d2).' size dict d2 (init: '.opts.d2_val_expr.')'
                        \ .', '.overlap_pc.'% overlap between d & d2)'
                        \ .': '.string(ti[-1])
        endfunc
    endif
endif

if opts.do_test
    let ti = []
    for t in range(opts.testnum)
        let start = reltime()
        call Testloop()
        redraw
    endfor

    call RemoveOutliers(ti)
    exe 'let sum = ' . join(ti, '+')
    let var = Variance(ti)

    $put ='avg:'.repeat(' ', 144).string(sum / len(ti))
    $put ='var:'.repeat(' ', 144).string(var)
    redraw
endif

redraw
sleep 3

wq! vim-test.out


