#
# config.mk.in -- autoconf template for Vim on Unix		vim:ts=8:sw=8:
#
# DO NOT EDIT config.mk!!  It will be overwritten by configure.
# Edit Makefile and run "make" or run ./configure with other arguments.
#
# Configure does not edit the makefile directly. This method is not the
# standard use of GNU autoconf, but it has two advantages:
#   a) The user can override every choice made by configure.
#   b) Modifications to the makefile are not lost when configure is run.
#
# I hope this is worth being nonstandard. jw.



VIMNAME		= vim
EXNAME		= ex
VIEWNAME	= view

CC		= /home/utils/gcc-4.8.2/bin//gcc
DEFS		= -DHAVE_CONFIG_H
CFLAGS		= -O2 -fno-strength-reduce -Wall -U_FORTIFY_SOURCE -D_FORTIFY_SOURCE=1
CPPFLAGS	= 
srcdir		= .

LDFLAGS		= -L. -fstack-protector   -rdynamic -Wl,-export-dynamic -Wl,-E  -L/home/utils/gcc-4.8.2/lib/ -L/home/utils/gcc-4.8.2/lib64/ -Wl,--as-needed
LIBS		= -lm -lelf -lnsl  -lselinux  -lncurses -lgpm
TAGPRG		= ctags -I INIT+ --fields=+S

CPP		= /home/utils/gcc-4.8.2/bin//gcc -E
CPP_MM		= M
DEPEND_CFLAGS_FILTER = | sed 's+-I */+-isystem /+g'
LINK_AS_NEEDED	= yes
X_CFLAGS	= -I/home/utils/X11R6/include/X11 
X_LIBS_DIR	= -L/home/utils/X11R6/lib64  
X_PRE_LIBS	=  -lSM -lICE -lXpm
X_EXTRA_LIBS	=  -lSM -lICE
X_LIBS		= -lXt -lX11

LUA_LIBS	= -L/home/utils/lua-5.2.2/lib -llua
LUA_SRC		= if_lua.c
LUA_OBJ		= objects/if_lua.o
LUA_CFLAGS	= -I/home/utils/lua-5.2.2/include
LUA_PRO		= if_lua.pro

MZSCHEME_LIBS	= 
MZSCHEME_SRC	= 
MZSCHEME_OBJ	= 
MZSCHEME_CFLAGS	= 
MZSCHEME_PRO	= 
MZSCHEME_EXTRA	= 
MZSCHEME_MZC	= 

PERL		= /home/utils/perl-5.16/5.16.2-nothreads-64/bin//perl
PERLLIB		= /home/utils/perl-5.16/5.16.2-nothreads-64/lib/5.16.2
PERL_XSUBPP	= /home/utils/perl-5.16/5.16.2-nothreads-64/lib/5.16.2/ExtUtils/xsubpp
PERL_LIBS	= -Wl,-E  -fstack-protector -L/usr/local/lib  -L/home/utils/perl-5.16/5.16.2-nothreads-64/lib/5.16.2/x86_64-linux/CORE -lperl -lnsl -ldl -lm -lcrypt -lutil -lc
SHRPENV		= 
PERL_SRC	= auto/if_perl.c if_perlsfio.c
PERL_OBJ	= objects/if_perl.o objects/if_perlsfio.o
PERL_PRO	= if_perl.pro if_perlsfio.pro
PERL_CFLAGS	=   -fstack-protector -I/usr/local/include -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64  -I/home/utils/perl-5.16/5.16.2-nothreads-64/lib/5.16.2/x86_64-linux/CORE 

PYTHON_SRC	= if_python.c
PYTHON_OBJ	= objects/if_python.o
PYTHON_CFLAGS	= -I/home/utils/Python-2.7.5/include/python2.7 -DPYTHON_HOME='"/home/utils/Python-2.7.5"' -pthread -fPIE
PYTHON_LIBS	= -L/home/utils/Python-2.7.5/lib/python2.7/config -lpython2.7 -lpthread -ldl -lutil -lm -Xlinker -export-dynamic
PYTHON_CONFDIR	= /home/utils/Python-2.7.5/lib/python2.7/config
PYTHON_GETPATH_CFLAGS = -DPYTHONPATH='":/home/rmondal/.local/lib/python2.7/site-packages/qtile-0.6-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/setuptools-0.9.8-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/pep8-1.4.6-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/pip-1.4.1-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/python_ldap-2.4.14-py2.7-linux-x86_64.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/suds-0.4-py2.6.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/analysis-0.1.7-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/matplotlib-1.4.3-py2.7-linux-x86_64.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/mock-1.0.1-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/nose-1.3.6-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/pyparsing-2.0.3-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/pytz-2015.4-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/python_dateutil-2.4.2-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/six-1.4.1-py2.7.egg:/home/utils/Python-2.7.5/lib/python2.7/site-packages/pygraphml-2.0-py2.7.egg:/home/utils/Python-2.7.5/lib/python27.zip:/home/utils/Python-2.7.5/lib/python2.7:/home/utils/Python-2.7.5/lib/python2.7/plat-linux2:/home/utils/Python-2.7.5/lib/python2.7/lib-tk:/home/utils/Python-2.7.5/lib/python2.7/lib-old:/home/utils/Python-2.7.5/lib/python2.7/lib-dynload:/home/rmondal/.local/lib/python2.7/site-packages:/home/utils/Python-2.7.5/lib/python2.7/site-packages:/home/utils/MySQL-python-1.2.4/lib/python2.7/site-packages:/home/utils/py2cairo-1.10.0/lib/python2.7/site-packages:/home/utils/python-dateutil-2.2/lib/python2.7/site-packages:/home/utils/dbus-python-0.84.0/lib/python2.7/site-packages:/home/utils/Python-2.7.5/lib/python2.7/site-packages:/home/utils/keybinder-v0.0.4/lib/python2.7/site-packages:/home/utils/openpyxl-1.6.2/lib/python2.7/site-packages:/home/utils/pandas-0.12.0/lib/python2.7/site-packages:/home/utils/peewee-2.1.5/lib/python2.7/site-packages:/home/utils/Python-2.7.5/lib/python2.7/site-packages/gtk-2.0:/home/utils/notify-python-0.1.1/lib/python2.7/site-packages/gtk-2.0:/home/utils/pytz-2013.7/lib/python2.7/site-packages:/home/utils/six-1.4.1/lib/python2.7/site-packages:/home/utils/terminator-0.97/lib/python2.7/site-packages:/home/utils/virtualenv-1.10.1/lib/python2.7/site-packages:/home/utils/virtualenvwrapper-4.1.1/lib/python2.7/site-packages:/home/utils/vte-0.25.1/lib/python2.7/site-packages/gtk-2.0:/home/utils/wxPython-2.9.5.0/lib/python2.7/site-packages:/home/utils/xpyb-1.3/lib/python2.7/site-packages:/home/utils/xcb-proto-1.7.1/lib/python2.7/site-packages:/home/utils/PyYAML-3.10/lib/python2.7/site-packages"' -DPREFIX='"/home/utils/Python-2.7.5"' -DEXEC_PREFIX='"/home/utils/Python-2.7.5"'

PYTHON3_SRC	= 
PYTHON3_OBJ	= 
PYTHON3_CFLAGS	= 
PYTHON3_LIBS	= 
PYTHON3_CONFDIR	= 

TCL		= 
TCL_SRC		= 
TCL_OBJ		= 
TCL_PRO		= 
TCL_CFLAGS	= 
TCL_LIBS	= 

HANGULIN_SRC	= 
HANGULIN_OBJ	= 

WORKSHOP_SRC	= 
WORKSHOP_OBJ	= 

NETBEANS_SRC	= netbeans.c
NETBEANS_OBJ	= objects/netbeans.o

RUBY		= /home/utils/ruby-2.1.0/bin//ruby
RUBY_SRC	= if_ruby.c
RUBY_OBJ	= objects/if_ruby.o
RUBY_PRO	= if_ruby.pro
RUBY_CFLAGS	= -I/home/utils/ruby-2.1.0/include/ruby-2.1.0 -I/home/utils/ruby-2.1.0/include/ruby-2.1.0/x86_64-linux -DRUBY_VERSION=21
RUBY_LIBS	= -Wl,-R -Wl,/home/utils/ruby-2.1.0/lib -L/home/utils/ruby-2.1.0/lib -lruby -lpthread -lrt -lgmp -ldl -lcrypt -lm  -L/home/utils/ruby-2.1.0/lib

SNIFF_SRC	= if_sniff.c
SNIFF_OBJ	= objects/if_sniff.o

AWK		= gawk

STRIP		= strip

EXEEXT		= 

COMPILEDBY	= Rajdeep <justrajdeep@gmail.com>

INSTALLVIMDIFF	= installvimdiff
INSTALLGVIMDIFF	= installgvimdiff
INSTALL_LANGS	= install-languages
INSTALL_TOOL_LANGS	= install-tool-languages

### sed command to fix quotes while creating pathdef.c
QUOTESED        = sed -e 's/[\\"]/\\&/g' -e 's/\\"/"/' -e 's/\\";$$/";/'

### Line break character as octal number for "tr"
NL		= "\\012"

### Top directory for everything
prefix		= /home/rmondal/local

### Top directory for the binary
exec_prefix	= ${prefix}

### Prefix for location of data files
BINDIR		= ${exec_prefix}/bin

### For autoconf 2.60 and later (avoid a warning)
datarootdir	= ${prefix}/share

### Prefix for location of data files
DATADIR		= ${datarootdir}

### Prefix for location of man pages
MANDIR		= ${datarootdir}/man

### Do we have a GUI
GUI_INC_LOC	= -I/usr/include/gtk-2.0 -I/usr/lib64/gtk-2.0/include -I/usr/include/atk-1.0 -I/usr/include/cairo -I/usr/include/pango-1.0 -I/usr/include/glib-2.0 -I/usr/lib64/glib-2.0/include -I/usr/include/freetype2 -I/usr/include/libpng12  
GUI_LIB_LOC	= -L/lib64  
GUI_SRC		= $(GTK_SRC)
GUI_OBJ		= $(GTK_OBJ)
GUI_DEFS	= $(GTK_DEFS)
GUI_IPATH	= $(GTK_IPATH)
GUI_LIBS_DIR	= $(GTK_LIBS_DIR)
GUI_LIBS1	= $(GTK_LIBS1)
GUI_LIBS2	= $(GTK_LIBS2)
GUI_INSTALL	= $(GTK_INSTALL)
GUI_TARGETS	= $(GTK_TARGETS)
GUI_MAN_TARGETS	= $(GTK_MAN_TARGETS)
GUI_TESTTARGET	= $(GTK_TESTTARGET)
GUI_TESTARG	= $(GTK_TESTARG)
GUI_BUNDLE	= $(GTK_BUNDLE)
NARROW_PROTO	= 
GUI_X_LIBS	= 
MOTIF_LIBNAME	= 
GTK_LIBNAME	= -L/lib64 -lgtk-x11-2.0 -lgdk-x11-2.0 -latk-1.0 -lgdk_pixbuf-2.0 -lm -lpangocairo-1.0 -lpango-1.0 -lcairo -lgobject-2.0 -lgmodule-2.0 -ldl -lglib-2.0  

### Any OS dependent extra source and object file
OS_EXTRA_SRC	= 
OS_EXTRA_OBJ	= 

### If the *.po files are to be translated to *.mo files.
MAKEMO		= yes

MSGFMT		= msgfmt

# Make sure that "make first" will run "make all" once configure has done its
# work.  This is needed when using the Makefile in the top directory.
first: all
