exe 'source' expand("<sfile>:p:h").'/util.vim'

func! SetUp()
  let s:starting_bufnr = bufnr('%')
  new
  call append(1, ["        one", "\ttwo", "    \tthree", "\tfour\tfour", "  \tfive   \tfive"])
  syntax enable
  syntax match Comment /four.\@=/
  runtime plugin/tohtml.vim
endfun

func! s:open_diff()
  set splitright
  bd!
  diffthis
  %y
  vnew
  put
  %s/three/THREE
  diffthis
endfun

func! Test_expand_normal_tab()
  let g:html_expand_tabs = 1
  set tabstop=8 noexpandtab vartabstop=
  let g:html_number_lines = 0
  let g:html_dynamic_folds = 0
  TOhtml
  call assert_true(search('^        one',   'w'), "line one mismatch")
  call assert_true(search('^        two',   'w'), "line two mismatch")
  call assert_true(search('^        three', 'w'), "line three mismatch")
  call assert_true(search('^        <span class="Comment">four</span>    four', 'w'), "line four mismatch")
  call assert_true(search('^        five    five', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()

  call s:open_diff()
  TOhtml
  0
  " diff buffer 1
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 1")
  call assert_true(search('^        two',   'W'), "line two mismatch in diff window 1")
  call assert_true(search('>        </span><span class="DiffText">three', 'W'), "line three mismatch in diff window 1")
  call assert_true(search('^        <span class="Comment">four</span>    four', 'W'), "line four mismatch in diff window 1")
  call assert_true(search('^        five    five', 'W'), "line five mismatch in diff window 1")
  " diff buffer 2
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 2")
  call assert_true(search('^        two',   'W'), "line two mismatch in diff window 2")
  call assert_true(search('>        </span><span class="DiffText">THREE', 'W'), "line three mismatch in diff window 2")
  call assert_true(search('^        four    four', 'W'), "line four mismatch in diff window 2")
  call assert_true(search('^        five    five', 'W'), "line five mismatch in diff window 2")

  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_keep_vartab()
  let g:html_expand_tabs = 0
  set tabstop=8 noexpandtab vartabstop=5,9
  let g:html_number_lines = 0
  let g:html_dynamic_folds = 0
  TOhtml
  call assert_true(search('^        one',   'w'), "line one mismatch")
  call assert_true(search('^\ttwo', 'w'), "line two mismatch")
  call assert_true(search('^    \tthree', 'w'), "line three mismatch")
  call assert_true(search('^\t<span class="Comment">four</span>\tfour', 'w'), "line four mismatch")
  call assert_true(search('^  \tfive   \tfive', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()

  call s:open_diff()
  TOhtml
  0
  " diff buffer 1
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 1")
  call assert_true(search('^\ttwo', 'W'), "line two mismatch in diff window 1")
  call assert_true(search('>    \t</span><span class="DiffText">three', 'W'), "line three mismatch in diff window 1")
  call assert_true(search('^\t<span class="Comment">four</span>\tfour', 'W'), "line four mismatch in diff window 1")
  call assert_true(search('^  \tfive   \tfive', 'W'), "line five mismatch in diff window 1")
  " diff buffer 2
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 2")
  call assert_true(search('^\ttwo', 'W'), "line two mismatch in diff window 2")
  call assert_true(search('>    \t</span><span class="DiffText">THREE', 'W'), "line three mismatch in diff window 2")
  call assert_true(search('^\tfour\tfour', 'W'), "line four mismatch in diff window 2")
  call assert_true(search('^  \tfive   \tfive', 'W'), "line five mismatch in diff window 2")
  
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_default_keep_tabs()
  unlet! g:html_expand_tabs
  set tabstop=8 noexpandtab vartabstop=
  let g:html_number_lines = 0
  let g:html_dynamic_folds = 0
  TOhtml
  call assert_true(search('^        one',   'w'), "line one mismatch")
  call assert_true(search('^\ttwo', 'w'), "line two mismatch")
  call assert_true(search('^    \tthree', 'w'), "line three mismatch")
  call assert_true(search('^\t<span class="Comment">four</span>\tfour', 'w'), "line four mismatch")
  call assert_true(search('^  \tfive   \tfive', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()

  call s:open_diff()
  TOhtml
  0
  " diff buffer 1
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 1")
  call assert_true(search('^\ttwo', 'W'), "line two mismatch in diff window 1")
  call assert_true(search('>    \t</span><span class="DiffText">three', 'W'), "line three mismatch in diff window 1")
  call assert_true(search('^\t<span class="Comment">four</span>\tfour', 'W'), "line four mismatch in diff window 1")
  call assert_true(search('^  \tfive   \tfive', 'W'), "line five mismatch in diff window 1")
  " diff buffer 2
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 2")
  call assert_true(search('^\ttwo', 'W'), "line two mismatch in diff window 2")
  call assert_true(search('>    \t</span><span class="DiffText">THREE', 'W'), "line three mismatch in diff window 2")
  call assert_true(search('^\tfour\tfour', 'W'), "line four mismatch in diff window 2")
  call assert_true(search('^  \tfive   \tfive', 'W'), "line five mismatch in diff window 2")

  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_default_expandtab_from_foldcol()
  unlet! g:html_expand_tabs
  set tabstop=8 noexpandtab vartabstop=
  let g:html_number_lines = 0
  let g:html_dynamic_folds = 1
  %fold
  TOhtml
  call assert_true(search('>        one',   'w'), "line one mismatch")
  call assert_true(search('>        two',   'w'), "line two mismatch")
  call assert_true(search('>        three', 'w'), "line three mismatch")
  call assert_true(search('>        <span class="Comment">four</span>    four', 'w'), "line four mismatch")
  call assert_true(search('>        five    five', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_default_expandtab_from_linenums()
  unlet! g:html_expand_tabs
  set tabstop=8 noexpandtab vartabstop=
  let g:html_number_lines = 1
  let g:html_dynamic_folds = 0
  TOhtml
  call assert_true(search('>        one',   'w'), "line one mismatch")
  call assert_true(search('>        two',   'w'), "line two mismatch")
  call assert_true(search('>        three', 'w'), "line three mismatch")
  call assert_true(search('>        <span class="Comment">four</span>    four', 'w'), "line four mismatch")
  call assert_true(search('>        five    five', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_default_expandtab_from_vartabs()
  unlet! g:html_expand_tabs
  set tabstop=8 noexpandtab vartabstop=5,9
  let g:html_number_lines = 0
  let g:html_dynamic_folds = 0
  TOhtml
  call assert_true(search('^        one',   'w'), "line one mismatch")
  call assert_true(search('^     two',   'w'), "line two mismatch")
  call assert_true(search('^     three', 'w'), "line three mismatch")
  call assert_true(search('^     <span class="Comment">four</span>     four', 'w'), "line four mismatch")
  call assert_true(search('^     five     five', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()

  call s:open_diff()
  TOhtml
  0
  " diff buffer 1
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 1")
  call assert_true(search('^     two',   'W'), "line two mismatch in diff window 1")
  call assert_true(search('>     </span><span class="DiffText">three', 'W'), "line three mismatch in diff window 1")
  call assert_true(search('^     <span class="Comment">four</span>     four', 'W'), "line four mismatch in diff window 1")
  call assert_true(search('^     five     five', 'W'), "line five mismatch in diff window 1")
  " diff buffer 2
  call assert_true(search('^        one',   'W'), "line one mismatch in diff window 2")
  call assert_true(search('^     two',   'W'), "line two mismatch in diff window 2")
  call assert_true(search('>     </span><span class="DiffText">THREE', 'W'), "line three mismatch in diff window 2")
  call assert_true(search('^     four     four', 'W'), "line four mismatch in diff window 2")
  call assert_true(search('^     five     five', 'W'), "line five mismatch in diff window 2")

  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_default_expandtab_from_setting()
  unlet! g:html_expand_tabs
  set tabstop=8 expandtab vartabstop=
  let g:html_number_lines = 0
  let g:html_dynamic_folds = 0
  TOhtml
  call assert_true(search('^        one',   'w'), "line one mismatch")
  call assert_true(search('^        two',   'w'), "line two mismatch")
  call assert_true(search('^        three', 'w'), "line three mismatch")
  call assert_true(search('^        <span class="Comment">four</span>    four', 'w'), "line four mismatch")
  call assert_true(search('^        five    five', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_default_expandtab_from_tabstop()
  unlet! g:html_expand_tabs
  set tabstop=9 noexpandtab vartabstop=
  let g:html_number_lines = 0
  let g:html_dynamic_folds = 0
  TOhtml
  call assert_true(search('^        one',   'w'), "line one mismatch")
  call assert_true(search('^         two',   'w'), "line two mismatch")
  call assert_true(search('^         three', 'w'), "line three mismatch")
  call assert_true(search('^         <span class="Comment">four</span>     four', 'w'), "line four mismatch")
  call assert_true(search('^         five     five', 'w'), "line five mismatch")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! TearDown()
  diffoff!
  exec 'b!' s:starting_bufnr
  only!
endfun
