exe 'source' expand("<sfile>:p:h").'/util.vim'

func! SetUp()
  let s:starting_bufnr = bufnr('%')
  new
  call append(1, ['one', 'two', 'three', 'four'])
  syntax enable
  syntax match Comment /two/
  runtime plugin/tohtml.vim
endfun

func! s:open_diff()
  bd!
  diffthis
  %y
  vnew
  put
  %s/three/THREE
  diffthis
endfun

func! s:gather_javascript_vars()
  0
  /^\s*<script/
  let l:script_beg = line('.')
  /^\s*<\/script/
  let l:script_end = line('.')
  let l:scriptlines = getline(l:script_beg, l:script_end)
  call filter(l:scriptlines, 'v:val =~ ''^\s*\%(var\s\+\)\?\k\+\s*==\@!''')
  call map(l:scriptlines, 'substitute(v:val, ''^\s*\%(var\s\+\)\?\<\(\k\+\)\s*=.*'', ''\1'', "")')
  call uniq(sort(l:scriptlines))
  return l:scriptlines
endfun

func! Test_all_variables_use_var()
  " turn on all options which use javascript so we can test all the scripts
  let g:html_prevent_copy = 'n'
  let g:html_number_lines = 1
  let g:html_dynamic_folds = 1
  let g:html_line_ids = 1
  let g:html_no_invalid = 1
  TOhtml
  let l:var_list = s:gather_javascript_vars()
  "echo l:var_list
  for l:var in l:var_list
    call assert_true(search('^\s*var\s\+'.l:var, 'w'), "javascript variable ".l:var.' declared without "var" keyword')
  endfor
  call Tohtml_test_util__assert_cur_buffer_valid()

  call s:open_diff()
  TOhtml
  let l:var_list = s:gather_javascript_vars()
  "echo l:var_list
  for l:var in l:var_list
    call assert_true(search('^\s*var\s\+'.l:var, 'w'), "javascript variable ".l:var.' declared without "var" keyword in diff mode')
  endfor
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! TearDown()
  diffoff!
  exec 'b!' s:starting_bufnr
  only!
endfun
