exe 'source' expand("<sfile>:p:h").'/util.vim'

func! SetUp()
  let s:starting_bufnr = bufnr('%')
  new
  call append(1, ['one', 'two', 'three', 'four'])
  syntax enable
  syntax match Comment /two/
  runtime plugin/tohtml.vim
  hi clear StatusLine
  hi clear DiffDelete
endfun

func! Test_cterm_progress_low_auto_simple()
  let g:colors_name = 'cterm_progress_low_auto_simple'
  exe 'hi StatusLine ctermbg=0 ctermfg='.(&t_Co-1)
  exe 'hi DiffDelete ctermbg=2 ctermfg='.(&t_Co-1)
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("2", synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_cterm_progress_low_auto_calculate()
  let g:colors_name = 'cterm_progress_low_calculate'
  exe 'hi StatusLine ctermbg=0 ctermfg='.(&t_Co-1)
  exe 'hi DiffDelete ctermbg=0 ctermfg='.(&t_Co-1)
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("1", synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_cterm_progress_manual()
  let g:colors_name = 'cterm_progress_manual'
  exe 'hi StatusLine ctermbg=0 ctermfg='.(&t_Co-1)
  exe 'hi DiffDelete ctermbg=0 ctermfg='.(&t_Co-1)
  exe 'hi TOhtmlProgress ctermbg=3 ctermfg='.(&t_Co-1)
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("3", synIDattr(synIDtrans(hlID("TOhtmlProgress_auto")), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_cterm_progress_high_auto_simple()
  let g:colors_name = 'cterm_progress_high_auto_simple'
  exe 'hi StatusLine cterm=reverse ctermbg=0 ctermfg='.(&t_Co-1)
  exe 'hi DiffDelete cterm=reverse ctermbg=2 ctermfg='.(&t_Co-3)
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal(string(&t_Co-3), synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_cterm_progress_high_auto_calculate()
  let g:colors_name = 'cterm_progress_high_calculate'
  exe 'hi StatusLine cterm=reverse ctermbg=0 ctermfg='.(&t_Co-1)
  exe 'hi DiffDelete cterm=reverse ctermbg=0 ctermfg='.(&t_Co-1)
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal(string(&t_Co-2), synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

" TODO: cterm with termguicolors

func! TearDown()
  exec 'b!' s:starting_bufnr
  only!
  unlet g:colors_name
endfun
