exe 'source' expand("<sfile>:p:h").'/util.vim'

if !has('gui')
  finish
endif

func! SetUp()
  if !has("gui_running")
    gui -f
  endif
  let s:starting_bufnr = bufnr('%')
  new
  call append(1, ['one', 'two', 'three', 'four'])
  syntax enable
  syntax match Comment /two/
  runtime plugin/tohtml.vim
  hi clear StatusLine
  hi clear DiffDelete
endfun

func! Test_gui_progress_low_auto_simple()
  let g:colors_name = 'gui_progress_low_auto_simple'
  hi StatusLine guibg=black guifg=#f0f0f0
  hi DiffDelete guibg=#000042 guifg=#f0f0f0
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("#000042", synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_gui_progress_low_auto_calculate()
  let g:colors_name = 'gui_progress_low_calculate'
  hi StatusLine guibg=black guifg=#f0f0f0
  hi DiffDelete guibg=black guifg=#f0f0f0
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("#161616", synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_gui_progress_manual()
  let g:colors_name = 'gui_progress_manual'
  hi StatusLine guibg=black guifg=#f0f0f0
  hi DiffDelete guibg=black guifg=#f0f0f0
  hi TOhtmlProgress guibg=#dead00
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("#dead00", synIDattr(synIDtrans(hlID("TOhtmlProgress_auto")), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_gui_progress_high_auto_simple()
  let g:colors_name = 'gui_progress_high_auto_simple'
  hi StatusLine gui=reverse guibg=black guifg=#f0f0f0
  hi DiffDelete gui=reverse guibg=#000042 guifg=#c0ffee
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("#c0ffee", synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

func! Test_gui_progress_high_auto_calculate()
  let g:colors_name = 'gui_progress_high_calculate'
  hi StatusLine gui=reverse guibg=black guifg=#f0f0f0
  hi DiffDelete gui=reverse guibg=black guifg=#f0f0f0
  TOhtml
  call assert_notequal(hlID("TOhtmlProgress_auto"), 0, "TOhtmlProgress highlight not defined")
  call assert_equal("#b4b4b4", synIDattr(hlID("TOhtmlProgress_auto"), "bg#"), "Progress bar background color mismatch")
endfun

" TODO: cterm with termguicolors

func! TearDown()
  exec 'b!' s:starting_bufnr
  only!
  unlet g:colors_name
endfun
