exe 'source' expand("<sfile>:p:h").'/util.vim'

func! SetUp()
  let s:starting_bufnr = bufnr('%')
  new
  call append(1, ['one', 'two', 'three', 'four'])
  syntax enable
  syntax match Comment /two/
  runtime plugin/tohtml.vim
endfun

func! s:open_diff()
  bd!
  diffthis
  %y
  vnew
  put
  %s/three/THREE
  diffthis
endfun

func! Test_script_tag_omitted()
  let g:html_dynamic_folds = 0
  let g:html_line_ids = 0
  TOhtml
  call assert_false(search('<script', 'w'), "script tag should be ommitted, but present in output")
  call Tohtml_test_util__assert_cur_buffer_valid()
  call s:open_diff()
  TOhtml
  call assert_false(search('<script', 'w'), "script tag should be ommitted, but present in diff mode")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

" TODO: script tag missing when dyn folds enabled but no folds exist?
func! Test_script_tag_dyn_folds()
  let g:html_dynamic_folds = 1
  let g:html_line_ids = 0
  TOhtml
  call assert_true(search('<script', 'w'), "script tag should be present for dynamic folds, but omitted in output")
  call Tohtml_test_util__assert_cur_buffer_valid()
  call s:open_diff()
  TOhtml
  call assert_true(search('<script', 'w'), "script tag for dynamic folds missing in diff mode")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_script_tag_linenums()
  let g:html_dynamic_folds = 0
  let g:html_line_ids = 1
  let g:html_number_lines = 1
  TOhtml
  call assert_true(search('<script', 'w'), "script tag should be present for line numbers, but omitted in output")
  call Tohtml_test_util__assert_cur_buffer_valid()
  call s:open_diff()
  TOhtml
  call assert_true(search('<script', 'w'), "script tag for line numbers missing for diff mode")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_script_tag_blank_linenums()
  let g:html_dynamic_folds = 0
  let g:html_line_ids = 1
  let g:html_number_lines = 0
  TOhtml
  call assert_true(search('<script', 'w'), "script tag should be present for jumping to line numbers which are not displayed, but omitted in output")
  call Tohtml_test_util__assert_cur_buffer_valid()
  call s:open_diff()
  TOhtml
  call assert_true(search('<script', 'w'), "script tag for jumping to line numbers missing from diff mode")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_script_tag_highlander()
  let g:html_number_lines = 1
  let g:html_dynamic_folds = 1
  let g:html_line_ids = 1
  TOhtml
  0
  call assert_true(search('<script', 'W'), "script tag should be present")
  call assert_false(search('<script', 'W'), "only one script tag should be present, multiple found")
  call Tohtml_test_util__assert_cur_buffer_valid()

  call s:open_diff()
  TOhtml
  0
  call assert_true(search('<script', 'W'), "script tag should be present in diff mode")
  call assert_false(search('<script', 'W'), "only one script tag should be present, multiple found in diff mode")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

" TODO: add tests for different variants of script tag for HTML vs. XHTML

func! TearDown()
  diffoff!
  exec 'b!' s:starting_bufnr
  only!
endfun
