exe 'source' expand("<sfile>:p:h").'/util.vim'

func! SetUp()
  let s:starting_bufnr = bufnr('%')
  new
  call append(1, ['one', 'two', 'three', 'four'])
  syntax enable
  syntax match Comment /two/
endfun

" note: these tests are for sourcing the 2html.vim script directly, so diff mode
" does not need to be tested, since that depends on the main plugin being
" sourced.

func! Test_script_version_nominal()
  run syntax/2html.vim
  let scripts = split(execute('scriptnames'), "\n")
  call filter(scripts, 'v:val =~ "plugin/tohtml.vim"')
  call assert_true(empty(scripts), "main tohtml plugin should not have been sourced")
  "/plugin-version/
  "call add(v:errors, getline('.'))
  call assert_true(search('plugin-version.*vim\d\+\.\d\+_v\d\+', 'w'), "could not find plugin version in output")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_script_version_override()
  let g:loaded_2html_plugin = "override"
  run plugin/tohtml.vim
  call assert_false(exists(":TOhtml"), "plugin should bail early if loaded is set")
  run syntax/2html.vim
  call assert_true(search('plugin-version.*override', 'w'), "could not find plugin version in output")
  call Tohtml_test_util__assert_cur_buffer_valid()
endfun

func! Test_script_version_piecemeal()
  let syntax_plugin_file = 'test_2html_dir/syntax/2html.vim'
  let main_plugin_file = 'test_2html_dir/plugin/tohtml.vim'

  if !isdirectory(fnamemodify(syntax_plugin_file, ":p:h"))
    call mkdir(fnamemodify(syntax_plugin_file, ":p:h"), 'p')
  endif
  if !isdirectory(fnamemodify(main_plugin_file, ":p:h"))
    call mkdir(fnamemodify(main_plugin_file, ":p:h"), 'p')
  endif
  if filereadable(syntax_plugin_file)
    call delete(syntax_plugin_file)
  endif
  if filereadable(main_plugin_file)
    call delete(main_plugin_file)
  endif
  call writefile(readfile(g:tohtml_test_basepath."/syntax/2html.vim"), syntax_plugin_file)
  exe 'source' syntax_plugin_file
  "/plugin-version/
  "call add(v:errors, getline('.'))
  call assert_true(search('plugin-version.*unknown', 'w'), "expected unknown version in output")
  call Tohtml_test_util__assert_cur_buffer_valid()

  call TearDown()
  call SetUp()

  call writefile(['test'], main_plugin_file)
  exe 'source' syntax_plugin_file
  "/plugin-version/
  "call add(v:errors, getline('.'))
  call assert_true(search('plugin-version.*unknown', 'w'), "expected unknown version in output")
  call Tohtml_test_util__assert_cur_buffer_valid()

  call delete(main_plugin_file)
  call delete(syntax_plugin_file)
  call system("rmdir ".fnamemodify(main_plugin_file, ":p:h"))
  call system("rmdir ".fnamemodify(syntax_plugin_file, ":p:h"))
endfun

func! TearDown()
  unlet! g:loaded_2html_plugin
  unlet! g:unloaded_tohtml_plugin
  exec 'b!' s:starting_bufnr
  only!
endfun
