
exe 'source' expand("<sfile>:p:h").'/util.vim'

func SetUp()
  set diffopt&
  set diffopt+=context:1
  " TODO: needs silent! because this throws exception on Windows but ONLY WHILE
  " RUNNING TESTS
  silent! set notermguicolors
  let s:starting_bufnr = bufnr('%')
  new
  call append(1, ['one', 'two', 'three', 'four'])
  syntax enable
  syntax match Comment /two/
  " Windows cmd.exe console can't change t_Co from 16, so use that for
  " consistency across platforms.
  set t_Co=16
  hi Comment ctermfg=Red guifg=#c0ffee
  runtime plugin/tohtml.vim
endfun

" TODO: this test fails in Windows under MinGW (msys2 distribution).
" It seems the test detects an error getting thrown for setting termguicolors
" option (although none displays when setting the option manually), and if the
" error is ignored, the colors don't actually appear anyway.
func Test_termguicolors()
  TOhtml
  $put ='<!-- '.v:progpath.' -->'
  $put ='<!-- t_Co='. &t_Co .' has(vcon)='.has('vcon').' has(vtp)='.has('vtp').' -->'
  call Tohtml_test_util__assert_cur_buffer_valid()
  " TODO: this is the part that fails, because on Windows Red translates to
  " color 12 for some reason, which is not red at all. Expected color here
  " corresponds to color 9 which actually is red.
  call assert_true(search('\.Comment\_s*{\_[^}]*\<color:\s*#ff6060'), "cterm color expected")
  call Tohtml_test_util__save_html_output()

  bd!
  " TODO: needs silent! because this throws exception on Windows but ONLY WHILE
  " RUNNING TESTS
  silent! set termguicolors
  TOhtml
  call Tohtml_test_util__assert_cur_buffer_valid()
  call assert_true(search('\.Comment\_s*{\_[^}]*\<color:\s*#c0ffee'), "gui color expected")
endfun

" TODO: test all the other term color logic! Background and foreground! Dark and
" light mode! Inverse color! Various t_Co values!

func TearDown()
  exec 'b!' s:starting_bufnr
  only!
endfun
