let g:tohtml_test_basepath = expand("<sfile>:p:h:h")
exe 'set rtp ^='.tohtml_test_basepath

func Tohtml_test_util__assert_cur_buffer_valid()
  call assert_true(executable('java'), "java runtime not found, cannot validate HTML")
  call assert_true(filereadable(g:tohtml_test_basepath.'/testdir/vnu.jar'), "vnu.jar validator not found, place in ".g:tohtml_test_basepath.'/testdir')
  let l:output = system('java -Xss2048k -jar '.g:tohtml_test_basepath.'/testdir/vnu.jar --asciiquotes --format text --no-langdetect -', getline(1, '$'))
  let l:validates = (0 == v:shell_error)
  " TODO: probably should do something about warnings (print them? log error?)
  call assert_true( l:validates , "Output does not validate:\n".l:output)
endfun

func Tohtml_test_util__assert_cur_buffer_invalid()
  call assert_true(executable('java'), "java runtime not found, cannot validate HTML")
  call assert_true(filereadable(g:tohtml_test_basepath.'/testdir/vnu.jar'), "vnu.jar validator not found, place in ".g:tohtml_test_basepath.'/testdir')
  let l:output = system('java -Xss2048k -jar '.g:tohtml_test_basepath.'/testdir/vnu.jar --asciiquotes --format text --no-langdetect -', getline(1, '$'))
  let l:validates = (0 == v:shell_error)
  call assert_false( l:validates , "HTML output should contain invalid markup")
endfun

func Tohtml_test_util__save_html_output()
  " name the file after the calling function
  let l:stack = split(expand("<sfile>"), '\.\.\| ')
  let l:caller = substitute(l:stack[-2], '\[\d\+\]', '', '')
  exe 'silent! saveas!' g:tohtml_test_basepath.'/testdir/'.l:caller.'.html'
endfun
