" vim-trig: Vim Trigger manager
" ============================

if exists('g:loaded_trigger')
	finish
endif
let g:loaded_trigger = 1

let s:cpo_save = &cpo
set cpo&vim

let s:start = 0

function! trigger#new()  "{{{

	let obj            = {}
	let obj.timerId    = -999
	let obj.interval   = 600  " Timer interval
	let obj.triggerObj = ""
	let obj.Func       = ""
	let obj.TheEnd     = 0

	let obj.setup              = function('s:setup(...)              ')
	let obj.Event_FileReadable = function('s:Event_FileReadable(file)')
	let obj.setEventDetection  = function('s:setEventDetection(event)')
	let obj.TimerHandler       = function('s:TimerHandler(timerId)   ')
	let obj.isTheEnd           = function('s:isTheEnd()              ')
	let obj.getTriggerObject   = function('s:getTriggerObject()      ')
	let obj.setTriggerObject   = function('s:setTriggerObject(object)')
	let obj.start              = function('s:start()                 ')

	return obj

endfunction "}}}
" functions {{{

function! s:setup(trigger) 
	call self.setTriggerObject  ( split(a:trigger,'@')[0] )
	call self.setEventDetection ( split(a:trigger,'@')[1] )
endfunction

function! s:Event_FileReadable(file) 
	return filereadable(a:file)
endfunction

function! s:setEventDetection(event) 
	if a:event == 'filereadable'
		let self.Func = function(self.Event_FileReadable, [self.getTriggerObject()])
	endif
endfunction

function! s:TimerHandler(timerId) 
	let timerId = copy(a:timerId)
	let t = timer_info(timerId)

	let eventResult = self.Func()
	call util#echomsg(s:start, t[0].repeat.' times to end. '.((eventResult==0)? '' : 'Yes, event reached'))
	if eventResult
		call timer_stop(a:timerId)
		let self.TheEnd=1
	endif
endfunction

function! s:isTheEnd() 
	return self.TheEnd
endfunction

function! s:getTriggerObject() 
	return self.triggerObj
endfunction

function! s:setTriggerObject(object) 
	let self.triggerObj = a:object
endfunction

function! s:start() 
	let maxTimes = 20
	let s:start = reltime()             
	let self.timerId = timer_start(self.interval, self.TimerHandler,
				\ {'repeat': maxTimes})
endfunction   "}}}
" vim: set ft=vim ff=dos fdm=marker ts=4 :expandtab:
