/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSchemaGeneration;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.MicrosoftPlugIn;
import er.extensions.eof.ERXEntityFKConstraintOrder;
import er.extensions.eof.ERXEntityOrder;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.jdbc.ERXJDBCPlugInUtilities;
import java.io.IOException;
import java.io.InputStream;

public class ERXMicrosoftPlugIn
extends MicrosoftPlugIn {
    private static final String QUERY_STRING_USE_BUNDLED_JDBC_INFO = "useBundledJdbcInfo";

    public ERXMicrosoftPlugIn(JDBCAdaptor adaptor) {
        super(adaptor);
    }

    protected boolean shouldUseBundledJdbcInfo() {
        boolean shouldUseBundledJdbcInfo = false;
        String url = this.connectionURL();
        if (url != null) {
            shouldUseBundledJdbcInfo = url.toLowerCase().matches(".*(\\?|\\?.*&)" + QUERY_STRING_USE_BUNDLED_JDBC_INFO.toLowerCase() + "=(true|yes)(;.*|\\&.*|$)");
        }
        return shouldUseBundledJdbcInfo;
    }

    public NSDictionary jdbcInfo() {
        NSDictionary jdbcInfo;
        if (this.shouldUseBundledJdbcInfo()) {
            NSLog.debug.appendln((Object)"Loading jdbcInfo from JDBCInfo.plist as opposed to using the JDBCPlugIn default implementation.");
            InputStream jdbcInfoStream = ERXMicrosoftPlugIn.class.getResourceAsStream("/ERXMicrosoftPlugInJDBCInfo.plist");
            if (jdbcInfoStream == null) {
                throw new IllegalStateException("Unable to find 'ERXMicrosoftPlugInJDBCInfo.plist' in this plugin jar.");
            }
            try {
                jdbcInfo = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)new NSData(jdbcInfoStream, 2048), (String)"US-ASCII");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load 'ERXMicrosoftPlugInJDBCInfo.plist' from this plugin jar.", e);
            }
        } else {
            jdbcInfo = super.jdbcInfo();
        }
        return jdbcInfo;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        NSLog.debug.appendln((Object)"Called createSynchronizationFactory");
        return new ERXMicrosoftSynchronizationFactory((EOAdaptor)this._adaptor);
    }

    public static class ERXMicrosoftSynchronizationFactory
    extends EOSynchronizationFactory {
        public String schemaCreationScriptForEntities(NSArray allEntities, NSDictionary options) {
            options = options != null ? options : NSDictionary.EmptyDictionary;
            NSArray groupedEntities = this.tableEntityGroupsForEntities(allEntities);
            ERXEntityFKConstraintOrder constraintOrder = new ERXEntityFKConstraintOrder(ERXJDBCPlugInUtilities.modelGroupForEntityGroups((NSArray)groupedEntities));
            ERXJDBCPlugInUtilities.EntityGroupDeleteOrderComparator entityOrderingComparator = new ERXJDBCPlugInUtilities.EntityGroupDeleteOrderComparator((ERXEntityOrder)constraintOrder);
            NSArray sortedEntities = NSArray.EmptyArray;
            try {
                sortedEntities = groupedEntities.sortedArrayUsingComparator((NSComparator)entityOrderingComparator);
            }
            catch (NSComparator.ComparisonException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            sortedEntities = ERXArrayUtilities.flatten((NSArray)sortedEntities);
            StringBuffer result = new StringBuffer();
            NSArray statements = this.schemaCreationStatementsForEntities(sortedEntities, options);
            int i = 0;
            int count = statements.count();
            while (i < count) {
                this.appendExpressionToScript((EOSQLExpression)statements.objectAtIndex(i), result);
                ++i;
            }
            return new String(result);
        }

        public NSArray dropTableStatementsForEntityGroups(NSArray entityGroups) {
            ERXEntityFKConstraintOrder constraintOrder = new ERXEntityFKConstraintOrder(ERXJDBCPlugInUtilities.modelGroupForEntityGroups((NSArray)entityGroups));
            ERXJDBCPlugInUtilities.EntityGroupDeleteOrderComparator entityOrderingComparator = new ERXJDBCPlugInUtilities.EntityGroupDeleteOrderComparator((ERXEntityOrder)constraintOrder);
            try {
                return super.dropTableStatementsForEntityGroups(entityGroups.sortedArrayUsingComparator((NSComparator)entityOrderingComparator));
            }
            catch (NSComparator.ComparisonException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }

        public NSArray primaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            String pkTable = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            NSMutableArray statements = new NSMutableArray();
            statements.addObject((Object)this._expressionForString("CREATE TABLE " + pkTable + " (NAME CHAR(40) PRIMARY KEY, PK INT)"));
            return statements;
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            return new NSArray((Object)this._expressionForString("DROP TABLE " + ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName()));
        }

        public NSArray _statementsToDeleteTableNamedOptions(String tableName, EOSchemaGeneration options) {
            return new NSArray((Object)this._expressionForString("DROP TABLE " + tableName));
        }

        public NSArray dropTableStatementsForEntityGroup(NSArray entityGroup) {
            if (entityGroup == null) {
                return NSArray.EmptyArray;
            }
            EOSQLExpression sqlExpr = this._expressionForString("DROP TABLE " + ((EOEntity)entityGroup.objectAtIndex(0)).externalName());
            return new NSArray((Object)sqlExpr);
        }

        public boolean supportsSchemaSynchronization() {
            return false;
        }

        public NSArray _statementsToDropPrimaryKeyConstraintsOnTableNamed(String tableName) {
            return NSArray.EmptyArray;
        }

        public NSArray statementsToRenameTableNamed(String tableName, String newName, EOSchemaGeneration options) {
            String aNewName;
            String aTableName = tableName;
            int lastDot = aTableName.lastIndexOf(46);
            if (lastDot != -1) {
                aTableName = aTableName.substring(lastDot + 1);
            }
            if ((lastDot = (aNewName = newName).lastIndexOf(46)) != -1) {
                aNewName = aNewName.substring(lastDot + 1);
            }
            return new NSArray((Object)this._expressionForString("execute sp_rename " + aTableName + ", " + aNewName));
        }

        public ERXMicrosoftSynchronizationFactory(EOAdaptor adaptor) {
            super(adaptor);
            NSLog.debug.appendln((Object)"Created ERXMicrosoftSynchronizationFactory");
        }
    }
}

