from OpenTAL.Static.Directory import Directory
from OpenTAL.Static.TAL_File import Defaults


from WebKit.Page import Page
import time,copy




class Articles(Page):
    
    def __init__(self):
        Page.__init__(self)
        self.rootSkin = Directory('/home/soif/Perso/Projects/WebWare/mortal/Skins')
        Defaults['bindings']['skin'] = self.getRootSkin

    def getRootSkin(self,dummy):
        return self.rootSkin

    def title(self):
        return 'Articles @ Webware'

    def writeContent(self):
        cache = self.application().cache
        
        req = self.request()
        data = None

        
        if req.hasField('action'):
            action = req.value('action')
            if  action == 'addArticle':
                self.addArticle(req.value('title'),req.value('text') )
            elif action == 'new':
                data = self.rootSkin.article_edit_form(article = None)
                
                
        # we want the default view 
        if not data:
            data = cache.getObject(self)
            if not data:
                articles = copy.copy(self.application().articlesManager.getArticles() )
                articles.reverse()
                data = self.rootSkin.articles_view_form(articles = articles )
                data = data.encode('utf-8')
                cache.register(self,data)
        self.response().setHeader('Content-type', 'text/html; charset=UTF-8')
        self.writeln(data)
        

    def addArticle(self,aTitle,aText):
        self.application().articlesManager.addArticle(aTitle,aText)
        self.application().cache.unregister(self)        

