# Modeling
from Modeling.CustomObject import CustomObject
from Modeling.Validation import ValidationException
from mx.DateTime import DateTimeFrom


class Article(CustomObject):
  """
  Articles are objects ...
  """
  
  __implements__ = CustomObject.__implements__
  
  def __init__(self):
    "Initializer"
    # Note: if you modify this method, it is a strong requirement that
    # every parameter gets a default value, since the framework needs to be
    # able to instanciate an object with no parameter at all.
    self._text = None
    self._title = None
  
  def entityName(self):
      "Used by the framework to link this object to its entity"
      return "Article" # do not change


  # Attribute: text

  def getText(self):
    "Return the Article / text attribute value"
    self.willRead()
    return self._text
  
  def setText(self, text):
    "Change the Article / text attribute value"
    self.willChange()
    self._text  = text
  
  def validateText(self, value):
    "Edit this to enforce custom business logic"
    #if len(value) < 3:
    if 0: # your custom bizlogic
      raise ValidationException
    return
 
  # Attribute: title

  def getTitle(self):
    "Return the Article / title attribute value"
    self.willRead()
    return self._title
  
  def setTitle(self, title):
    "Change the Article / title attribute value"
    self.willChange()
    self._title  = title
  
  def validateTitle(self, value):
    "Edit this to enforce custom business logic"
    if 0: # your custom bizlogic
      raise ValidationException
    return
    
